/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.toggleable_enchantments.packet;

import net.liukrast.toggleable_enchantments.TEConstants;
import net.liukrast.toggleable_enchantments.registry.RegisterDataComponents;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.lwjgl.system.NonnullDefault;

@NonnullDefault
public record ChangeGroupPacket(ResourceLocation enchantment, int group) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ChangeGroupPacket> PACKET_TYPE = new CustomPacketPayload.Type(TEConstants.id("change_group"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ChangeGroupPacket> CODEC = StreamCodec.ofMember(ChangeGroupPacket::write, ChangeGroupPacket::new);

    public ChangeGroupPacket(RegistryFriendlyByteBuf buf) {
        this(buf.readResourceLocation(), buf.readInt());
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeResourceLocation(this.enchantment);
        buf.writeInt(this.group);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PACKET_TYPE;
    }

    public static void handle(ChangeGroupPacket packet, Player ctx) {
        Registry enchantRegistry = ctx.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        Holder.Reference enchantment = enchantRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)packet.enchantment));
        ItemStack stack = ctx.getMainHandItem();
        ItemEnchantments groups = (ItemEnchantments)stack.getOrDefault(RegisterDataComponents.ENCHANTMENT_GROUPS, (Object)ItemEnchantments.EMPTY);
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(groups);
        mutable.set((Holder)enchantment, packet.group);
        stack.set(RegisterDataComponents.ENCHANTMENT_GROUPS, (Object)mutable.toImmutable());
    }
}

