/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.toggleable_enchantments.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import java.util.function.Consumer;
import net.liukrast.toggleable_enchantments.registry.RegisterDataComponents;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnchantmentHelper.class})
public class EnchantmentHelperMixin {
    @Inject(method={"updateEnchantments"}, at={@At(value="INVOKE", target="Ljava/util/function/Consumer;accept(Ljava/lang/Object;)V")})
    private static void toggleable_enchantments$updateEnchantments(ItemStack stack, Consumer<ItemEnchantments.Mutable> updater, CallbackInfoReturnable<ItemEnchantments> cir, @Local ItemEnchantments.Mutable mutable) {
        ItemEnchantments disabled = (ItemEnchantments)stack.getOrDefault(RegisterDataComponents.DISABLED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        disabled.entrySet().forEach(e -> mutable.set((Holder)e.getKey(), e.getIntValue()));
        stack.set(RegisterDataComponents.DISABLED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        stack.set(RegisterDataComponents.ENCHANTMENT_GROUPS, (Object)ItemEnchantments.EMPTY);
    }

    @Inject(method={"setEnchantments"}, at={@At(value="HEAD")})
    private static void toggleable_enchantments$setEnchantments(ItemStack stack, ItemEnchantments enchantments, CallbackInfo ci) {
        ItemEnchantments disabled = (ItemEnchantments)stack.getOrDefault(RegisterDataComponents.DISABLED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(disabled);
        mutable.removeIf(holder -> enchantments.entrySet().stream().anyMatch(holder1 -> holder.getRegisteredName().equals(((Holder)holder1.getKey()).getRegisteredName())));
        stack.set(RegisterDataComponents.DISABLED_ENCHANTMENTS, (Object)mutable.toImmutable());
        stack.set(RegisterDataComponents.ENCHANTMENT_GROUPS, (Object)ItemEnchantments.EMPTY);
    }

    @Inject(method={"getEnchantmentsForCrafting"}, at={@At(value="RETURN")}, cancellable=true)
    private static void toggleable_enchantments$getEnchantmentsForCrafting(ItemStack stack, CallbackInfoReturnable<ItemEnchantments> cir) {
        ItemEnchantments disabled = (ItemEnchantments)stack.getOrDefault(RegisterDataComponents.DISABLED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        ItemEnchantments enabled = (ItemEnchantments)cir.getReturnValue();
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(enabled);
        disabled.entrySet().forEach(e -> mutable.upgrade((Holder)e.getKey(), e.getIntValue()));
        cir.setReturnValue((Object)mutable.toImmutable());
    }

    @Inject(method={"hasAnyEnchantments"}, at={@At(value="RETURN")}, cancellable=true)
    private static void toggleable_enchantments$hasAnyEnchantments(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)(cir.getReturnValueZ() || !((ItemEnchantments)stack.getOrDefault(RegisterDataComponents.DISABLED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).isEmpty() ? 1 : 0));
    }
}

