/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.toggleable_enchantments;

import java.util.ArrayList;
import java.util.List;
import net.liukrast.toggleable_enchantments.registry.RegisterDataComponents;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TEConstants {
    public static final String MOD_ID = "toggleable_enchantments";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"toggleable_enchantments");
    public static final String PACKET_VERSION = "1.0.1";

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static void toggleEnchantments(ItemStack stack, List<Holder<Enchantment>> enchantments, @Nullable Player player) {
        ItemEnchantments.Mutable enabled = new ItemEnchantments.Mutable((ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY));
        ItemEnchantments.Mutable disabled = new ItemEnchantments.Mutable((ItemEnchantments)stack.getOrDefault(RegisterDataComponents.DISABLED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY));
        ArrayList<String> enabled1 = new ArrayList<String>();
        ArrayList<String> disabled1 = new ArrayList<String>();
        for (Holder<Enchantment> enchantment : enchantments) {
            if (!stack.isEmpty()) {
                int level;
                boolean enable = enabled.getLevel(enchantment) == 0;
                int n = level = enabled.getLevel(enchantment) == 0 ? disabled.getLevel(enchantment) : enabled.getLevel(enchantment);
                if (level > 0) {
                    if (enable) {
                        disabled.removeIf(holder -> holder.equals((Object)enchantment));
                        enabled.upgrade(enchantment, level);
                        enabled1.add(((Enchantment)enchantment.value()).description().copy().getString());
                        continue;
                    }
                    enabled.removeIf(holder -> holder.equals((Object)enchantment));
                    disabled.upgrade(enchantment, level);
                    disabled1.add(((Enchantment)enchantment.value()).description().copy().getString());
                    continue;
                }
                LOGGER.error("Enchantment toggle failed. ItemStack {} does not have {}", (Object)stack, (Object)enchantment.getRegisteredName());
                continue;
            }
            LOGGER.error("Enchantment toggle failed. ItemStack {} is empty", (Object)stack);
        }
        ItemEnchantments fEnabled = enabled.toImmutable();
        ItemEnchantments fDisabled = disabled.toImmutable();
        if (fEnabled.isEmpty()) {
            stack.remove(DataComponents.ENCHANTMENTS);
        } else {
            stack.set(DataComponents.ENCHANTMENTS, (Object)fEnabled);
        }
        if (fDisabled.isEmpty()) {
            stack.remove(RegisterDataComponents.DISABLED_ENCHANTMENTS);
        } else {
            stack.set(RegisterDataComponents.DISABLED_ENCHANTMENTS, (Object)fDisabled);
        }
        if (player != null) {
            if (!enabled1.isEmpty()) {
                player.displayClientMessage((Component)Component.translatable((String)"toggleable_enchantments.enable", (Object[])new Object[]{String.join((CharSequence)", ", enabled1), stack.getDisplayName()}), false);
            }
            if (!disabled1.isEmpty()) {
                player.displayClientMessage((Component)Component.translatable((String)"toggleable_enchantments.disable", (Object[])new Object[]{String.join((CharSequence)", ", disabled1), stack.getDisplayName()}), false);
            }
        }
    }
}

