package net.liukrast.toggleable_enchantments.screen;

import net.liukrast.toggleable_enchantments.TEConstants;
import net.liukrast.toggleable_enchantments.packet.ChangeGroupPacket;
import net.liukrast.toggleable_enchantments.packet.ToggleEnchantmentPacket;
import net.liukrast.toggleable_enchantments.platform.TEServices;
import net.liukrast.toggleable_enchantments.registry.RegisterDataComponents;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1887;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import it.unimi.dsi.fastutil.objects.Object2IntMap.Entry;
import org.lwjgl.system.NonnullDefault;

import java.util.*;
import java.util.stream.Collectors;

@NonnullDefault
public class TEScreen extends class_437 {
    public static final class_2960 TEXTURE = TEConstants.id("textures/gui/toggleable_enchantments.png");
    public static final class_2960 BUTTON = TEConstants.id("toggle_button");
    public static final class_2561 TITLE = class_2561.method_43471("container.toggleable_enchantments");

    private static final List<class_2561> TOOLTIP = Arrays.asList(new class_2561[]{
            class_2561.method_43471("container.toggleable_enchantments.hotkey_group"),
            class_2561.method_43471("container.toggleable_enchantments.hotkey_group.help")
    });

    private static final int IMAGE_W = 176, IMAGE_H = 144;
    private static final int TOP_OFFSET = 19;
    private static final int BUTTON_W = 16, BUTTON_OFFSET = 7;
    public TEScreen() {
        super(TITLE);
    }

    @Override
    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25420(guiGraphics, mouseX, mouseY, partialTick);
        int leftPos = (this.field_22789- IMAGE_W)>>1;
        int topPos = (this.field_22790- IMAGE_H)>>1;
        guiGraphics.method_25290(class_1921::method_62277, TEXTURE, leftPos, topPos, 0, 0, IMAGE_W, IMAGE_H, 256, 256);
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        int leftPos = (this.field_22789-IMAGE_W)>>1;
        int topPos = (this.field_22790-IMAGE_H)>>1;
        int i = 0;
        for(var entry : enchantmentsEntrySet()) {
            var subEntry = entry.getKey();
            var holder = subEntry.getKey();
            boolean enabled = entry.getValue();
            int level = subEntry.getIntValue();
            assert class_310.method_1551().field_1724 != null;
            int group = class_310.method_1551().field_1724.method_6047().method_58695(RegisterDataComponents.ENCHANTMENT_GROUPS, class_9304.field_49385).method_57536(holder);
            if(level > 0) {
                var comp = class_1887.method_8179(holder, level).method_27662().method_27692(class_124.field_1068);
                boolean hovered = mouseX >= leftPos + IMAGE_W - BUTTON_W - BUTTON_OFFSET && mouseX < leftPos + 176 - BUTTON_OFFSET && mouseY >= topPos + i*12 + TOP_OFFSET && mouseY < topPos + i*12 + 8 + TOP_OFFSET;
                guiGraphics.method_27535(this.field_22793, comp, leftPos + 8, topPos + i*12 + TOP_OFFSET, -1);
                guiGraphics.method_25303(this.field_22793, group == 0 ? "-" : String.valueOf(group), leftPos + 130, topPos + i*12 + TOP_OFFSET, -1);
                guiGraphics.method_52708(
                        class_1921::method_62277,
                        BUTTON,
                        32, 16,
                        (hovered ? BUTTON_W : 0),
                        enabled ? 0 : 8,
                        leftPos + IMAGE_W - BUTTON_W - BUTTON_OFFSET,
                        topPos + i*12 + TOP_OFFSET,
                        BUTTON_W, 8
                );
            }
            i++;
        }
        i = 0;
        for(var entry : enchantmentsEntrySet()) {
            var subEntry = entry.getKey();
            int level = subEntry.getIntValue();
            assert class_310.method_1551().field_1724 != null;
            if(level > 0) {
                boolean hovered = mouseX >= leftPos + 130 && mouseX < leftPos + 152 && mouseY >= topPos + i*12 + TOP_OFFSET -2 && mouseY < topPos + i*12 + TOP_OFFSET + 10;
                if(hovered) {
                    guiGraphics.method_64038(this.field_22793, TOOLTIP, Optional.empty(), mouseX, mouseY);
                }
            }
            i++;
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        int leftPos = (this.field_22789-IMAGE_W)>>1;
        int topPos = (this.field_22790-IMAGE_H)>>1;
        int i = 0;
        for(var entry : enchantmentsEntrySet()) {
            var subEntry = entry.getKey();
            var holder = subEntry.getKey();
            int level = subEntry.getIntValue();
            if(level > 0) {
                boolean hovered = mouseX >= leftPos + IMAGE_W - BUTTON_W - BUTTON_OFFSET && mouseX < leftPos + 176 - BUTTON_OFFSET && mouseY >= topPos + i*12 + TOP_OFFSET && mouseY < topPos + i*12 + 8 + TOP_OFFSET;
                i++;
                if(!hovered) continue;
                var level1 = class_310.method_1551().field_1687;
                if(level1 == null) continue;
                var access = level1.method_30349().method_30530(class_7924.field_41265);
                class_2960 id = access.method_10221(holder.comp_349());
                if(id == null) continue;
                TEServices.PLATFORM.send2S(new ToggleEnchantmentPacket(List.of(id), class_1304.field_6173));
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        int leftPos = (this.field_22789-IMAGE_W)>>1;
        int topPos = (this.field_22790-IMAGE_H)>>1;
        int i = 0;
        for(var entry : enchantmentsEntrySet()) {
            var subEntry = entry.getKey();
            var holder = subEntry.getKey();
            int level = subEntry.getIntValue();
            assert class_310.method_1551().field_1724 != null;
            int group = class_310.method_1551().field_1724.method_6047().method_58695(RegisterDataComponents.ENCHANTMENT_GROUPS, class_9304.field_49385).method_57536(holder);
            if(level > 0) {
                boolean hovered = mouseX >= leftPos + 130 && mouseX < leftPos + 152 && mouseY >= topPos + i*12 + TOP_OFFSET -2 && mouseY < topPos + i*12 + TOP_OFFSET + 10;
                i++;
                if(!hovered) continue;
                var level1 = class_310.method_1551().field_1687;
                if(level1 == null) continue;
                var access = level1.method_30349().method_30530(class_7924.field_41265);
                class_2960 id = access.method_10221(holder.comp_349());
                if(id == null) continue;
                TEServices.PLATFORM.send2S(new ChangeGroupPacket(id, (int) Math.clamp(group + scrollY, 0, 9)));
                return true;
            }
        }
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    private Set<Map.Entry<Entry<class_6880<class_1887>>, Boolean>> enchantmentsEntrySet() {
        var player = class_310.method_1551().field_1724;
        if(player == null) {
            this.method_25419();
            return new HashSet<>();
        }
        var stack = player.method_6047();
        if(stack.method_7960()) this.method_25419();
        var enabled = stack.method_58657();
        var disabled = stack.method_58695(RegisterDataComponents.DISABLED_ENCHANTMENTS, class_9304.field_49385);
        final Map<Entry<class_6880<class_1887>>, Boolean> map = new HashMap<>();
        enabled.method_57539().forEach(e -> map.put(e, true));
        disabled.method_57539().forEach(e -> map.put(e, false));
        return map.entrySet()
                .stream()
                .sorted(Comparator.comparing(e -> e.getKey().getKey().method_55840()))
                .collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public boolean method_25421() {
        return false;
    }
}
