package net.liukrast.toggleable_enchantments.packet;

import net.liukrast.toggleable_enchantments.TEConstants;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.lwjgl.system.NonnullDefault;

import java.util.ArrayList;
import java.util.List;

@NonnullDefault
public record ToggleEnchantmentPacket(List<class_2960> enchantment, class_1304 slot) implements class_8710 {
    public static final class_9154<ToggleEnchantmentPacket> PACKET_TYPE = new class_9154<>(TEConstants.id("toggle_enchantment"));
    public static final class_9139<class_9129, ToggleEnchantmentPacket> CODEC = class_9139.method_56438(ToggleEnchantmentPacket::write, ToggleEnchantmentPacket::new);

    public ToggleEnchantmentPacket(class_9129 buf) {
        this(buf.method_34068(ArrayList::new, class_2960.field_48267), fromInt(buf.readInt()));
    }

    public void write(class_9129 buf) {
        buf.method_34062(enchantment, class_2960.field_48267);
        buf.method_53002(toInt(slot));
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return PACKET_TYPE;
    }

    private static int toInt(class_1304 slot) {
        if(slot.method_5925() == class_1304.class_1305.field_6177) return slot.method_5927();
        return slot.method_5927() + 2;
    }

    public static class_1304 fromInt(int value) {
        return switch (value) {
            case 1 -> class_1304.field_6171;
            case 2 -> class_1304.field_6166;
            case 3 -> class_1304.field_6172;
            case 4 -> class_1304.field_6174;
            case 5 -> class_1304.field_6169;
            default -> class_1304.field_6173;
        };
    }

    public static void handle(ToggleEnchantmentPacket packet, class_1657 ctx) {
        var enchantRegistry = ctx.method_37908().method_30349().method_30530(class_7924.field_41265);
        var list = packet.enchantment.stream().map(e -> ((class_6880<class_1887>)enchantRegistry.method_46747(class_5321.method_29179(class_7924.field_41265, e)))).toList();
        class_1799 stack = ctx.method_6118(packet.slot);
        if(!list.isEmpty()) TEConstants.toggleEnchantments(stack, list, ctx);
    }
}
