package net.liukrast.toggleable_enchantments.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.liukrast.toggleable_enchantments.mixin_helpers.IFlagEnchantment;
import net.liukrast.toggleable_enchantments.registry.RegisterDataComponents;
import net.minecraft.class_10712;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_9299;
import net.minecraft.class_9331;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.Consumer;

@Mixin(class_1799.class)
public abstract class ItemStackMixin {

    @Shadow public abstract <T extends class_9299> void addToTooltip(class_9331<T> component, class_1792.class_9635 context, class_10712 tooltipDisplay, Consumer<class_2561> tooltipAdder, class_1836 tooltipFlag);

    @Inject(
            method = "addDetailsToTooltip",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/item/ItemStack;addToTooltip(Lnet/minecraft/core/component/DataComponentType;Lnet/minecraft/world/item/Item$TooltipContext;Lnet/minecraft/world/item/component/TooltipDisplay;Ljava/util/function/Consumer;Lnet/minecraft/world/item/TooltipFlag;)V",
                    ordinal = 16,
                    shift = At.Shift.AFTER
            )
    )
    private void addDetailsToTooltip(class_1792.class_9635 context, class_10712 tooltipDisplay, class_1657 player, class_1836 tooltipFlag, Consumer<class_2561> tooltipAdder, CallbackInfo ci) {
        addToTooltip(RegisterDataComponents.DISABLED_ENCHANTMENTS, context, tooltipDisplay, tooltipAdder, tooltipFlag);
    }

    @ModifyExpressionValue(
            method = "addToTooltip",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/item/ItemStack;get(Lnet/minecraft/core/component/DataComponentType;)Ljava/lang/Object;"))
    private Object addToTooltip(Object original, @Local(argsOnly = true) class_9331<?> componentType) {
        if(componentType == RegisterDataComponents.DISABLED_ENCHANTMENTS && original != null) ((IFlagEnchantment)original).toggleable_enchantments$setDisabled(true);
        return original;
    }
}
