package net.liukrast.toggleable_enchantments.mixin;

import net.liukrast.toggleable_enchantments.mixin_helpers.IFlagEnchantment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_9304;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(class_9304.class)
@Debug(export = true)
public class ItemEnchantmentsMixin implements IFlagEnchantment {

    @Unique
    boolean toggleable_enchantments$disabled;

    @ModifyArg(method = "addToTooltip", at = @At(value = "INVOKE", target = "Ljava/util/function/Consumer;accept(Ljava/lang/Object;)V"))
    private <T> T toggleable_enchantments$addToTooltip(T t) {
        if(!toggleable_enchantments$disabled) return t;
        class_2561 arg = (class_2561) t;
        // noinspection unchecked
        return (T)class_2561.method_43470("❌ ").method_27692(class_124.field_1061).method_10852(arg);
    }

    @Override
    public void toggleable_enchantments$setDisabled(boolean disabled) {
        this.toggleable_enchantments$disabled = disabled;
    }
}
