package net.liukrast.toggleable_enchantments.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import net.liukrast.toggleable_enchantments.registry.RegisterDataComponents;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_9304;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.function.Consumer;

@Mixin(class_1890.class)
public class EnchantmentHelperMixin {
    @Inject(method = "updateEnchantments", at = @At(value = "INVOKE", target = "Ljava/util/function/Consumer;accept(Ljava/lang/Object;)V"))
    private static void toggleable_enchantments$updateEnchantments(class_1799 stack, Consumer<class_9304.class_9305> updater, CallbackInfoReturnable<class_9304> cir, @Local class_9304.class_9305 mutable) {
        class_9304 disabled = stack.method_58695(RegisterDataComponents.DISABLED_ENCHANTMENTS, class_9304.field_49385);
        disabled.method_57539().forEach(e->mutable.method_57547(e.getKey(), e.getIntValue()));
        stack.method_57379(RegisterDataComponents.DISABLED_ENCHANTMENTS, class_9304.field_49385);
        stack.method_57379(RegisterDataComponents.ENCHANTMENT_GROUPS, class_9304.field_49385);
    }

    @Inject(method = "setEnchantments", at = @At("HEAD"))
    private static void toggleable_enchantments$setEnchantments(class_1799 stack, class_9304 enchantments, CallbackInfo ci) {
        class_9304 disabled = stack.method_58695(RegisterDataComponents.DISABLED_ENCHANTMENTS, class_9304.field_49385);
        var mutable = new class_9304.class_9305(disabled);
        mutable.method_57548(holder -> enchantments.method_57539().stream().anyMatch(holder1 -> holder.method_55840().equals(holder1.getKey().method_55840())));
        stack.method_57379(RegisterDataComponents.DISABLED_ENCHANTMENTS, mutable.method_57549());
        stack.method_57379(RegisterDataComponents.ENCHANTMENT_GROUPS, class_9304.field_49385);
    }

    @Inject(method = "getEnchantmentsForCrafting", at = @At("RETURN"), cancellable = true)
    private static void toggleable_enchantments$getEnchantmentsForCrafting(class_1799 stack, CallbackInfoReturnable<class_9304> cir) {
        class_9304 disabled = stack.method_58695(RegisterDataComponents.DISABLED_ENCHANTMENTS, class_9304.field_49385);
        class_9304 enabled = cir.getReturnValue();
        class_9304.class_9305 mutable = new class_9304.class_9305(enabled);
        disabled.method_57539().forEach(e -> mutable.method_57550(e.getKey(), e.getIntValue()));
        cir.setReturnValue(mutable.method_57549());
    }

    @Inject(method = "hasAnyEnchantments", at = @At("RETURN"), cancellable = true)
    private static void toggleable_enchantments$hasAnyEnchantments(class_1799 stack, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue(cir.getReturnValueZ() || !stack.method_58695(RegisterDataComponents.DISABLED_ENCHANTMENTS, class_9304.field_49385).method_57543());
    }
}
