/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.toggleable_enchantments.screen;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.liukrast.toggleable_enchantments.TEConstants;
import net.liukrast.toggleable_enchantments.packet.ChangeGroupPacket;
import net.liukrast.toggleable_enchantments.packet.ToggleEnchantmentPacket;
import net.liukrast.toggleable_enchantments.platform.TEServices;
import net.liukrast.toggleable_enchantments.registry.RegisterDataComponents;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.lwjgl.system.NonnullDefault;

@NonnullDefault
public class TEScreen
extends Screen {
    public static final ResourceLocation TEXTURE = TEConstants.id("textures/gui/toggleable_enchantments.png");
    public static final ResourceLocation BUTTON = TEConstants.id("toggle_button");
    public static final Component TITLE = Component.translatable((String)"container.toggleable_enchantments");
    private static final List<Component> TOOLTIP = Arrays.asList(Component.translatable((String)"container.toggleable_enchantments.hotkey_group"), Component.translatable((String)"container.toggleable_enchantments.hotkey_group.help"));
    private static final int IMAGE_W = 176;
    private static final int IMAGE_H = 144;
    private static final int TOP_OFFSET = 19;
    private static final int BUTTON_W = 16;
    private static final int BUTTON_OFFSET = 7;

    public TEScreen() {
        super(TITLE);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        int leftPos = this.width - 176 >> 1;
        int topPos = this.height - 144 >> 1;
        guiGraphics.blit(RenderType::guiTextured, TEXTURE, leftPos, topPos, 0.0f, 0.0f, 176, 144, 256, 256);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Object2IntMap.Entry<Holder<Enchantment>> subEntry;
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int leftPos = this.width - 176 >> 1;
        int topPos = this.height - 144 >> 1;
        int i = 0;
        for (Map.Entry<Object2IntMap.Entry<Holder<Enchantment>>, Boolean> entry : this.enchantmentsEntrySet()) {
            subEntry = entry.getKey();
            Holder holder = (Holder)subEntry.getKey();
            boolean enabled = entry.getValue();
            int level = subEntry.getIntValue();
            assert (Minecraft.getInstance().player != null);
            int group = ((ItemEnchantments)Minecraft.getInstance().player.getMainHandItem().getOrDefault(RegisterDataComponents.ENCHANTMENT_GROUPS, (Object)ItemEnchantments.EMPTY)).getLevel(holder);
            if (level > 0) {
                MutableComponent comp = Enchantment.getFullname((Holder)holder, (int)level).plainCopy().withStyle(ChatFormatting.WHITE);
                boolean hovered = mouseX >= leftPos + 176 - 16 - 7 && mouseX < leftPos + 176 - 7 && mouseY >= topPos + i * 12 + 19 && mouseY < topPos + i * 12 + 8 + 19;
                guiGraphics.drawString(this.font, (Component)comp, leftPos + 8, topPos + i * 12 + 19, -1);
                guiGraphics.drawString(this.font, group == 0 ? "-" : String.valueOf(group), leftPos + 130, topPos + i * 12 + 19, -1);
                guiGraphics.blitSprite(RenderType::guiTextured, BUTTON, 32, 16, hovered ? 16 : 0, enabled ? 0 : 8, leftPos + 176 - 16 - 7, topPos + i * 12 + 19, 16, 8);
            }
            ++i;
        }
        i = 0;
        for (Map.Entry<Object2IntMap.Entry<Holder<Enchantment>>, Boolean> entry : this.enchantmentsEntrySet()) {
            subEntry = entry.getKey();
            int level = subEntry.getIntValue();
            assert (Minecraft.getInstance().player != null);
            if (level > 0) {
                boolean hovered;
                boolean bl = hovered = mouseX >= leftPos + 130 && mouseX < leftPos + 152 && mouseY >= topPos + i * 12 + 19 - 2 && mouseY < topPos + i * 12 + 19 + 10;
                if (hovered) {
                    guiGraphics.renderTooltip(this.font, TOOLTIP, Optional.empty(), mouseX, mouseY);
                }
            }
            ++i;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int leftPos = this.width - 176 >> 1;
        int topPos = this.height - 144 >> 1;
        int i = 0;
        for (Map.Entry<Object2IntMap.Entry<Holder<Enchantment>>, Boolean> entry : this.enchantmentsEntrySet()) {
            Registry access;
            ResourceLocation id;
            ClientLevel level1;
            Object2IntMap.Entry<Holder<Enchantment>> subEntry = entry.getKey();
            Holder holder = (Holder)subEntry.getKey();
            int level = subEntry.getIntValue();
            if (level <= 0) continue;
            boolean hovered = mouseX >= (double)(leftPos + 176 - 16 - 7) && mouseX < (double)(leftPos + 176 - 7) && mouseY >= (double)(topPos + i * 12 + 19) && mouseY < (double)(topPos + i * 12 + 8 + 19);
            ++i;
            if (!hovered || (level1 = Minecraft.getInstance().level) == null || (id = (access = level1.registryAccess().lookupOrThrow(Registries.ENCHANTMENT)).getKey((Object)((Enchantment)holder.value()))) == null) continue;
            TEServices.PLATFORM.send2S(new ToggleEnchantmentPacket(List.of(id), EquipmentSlot.MAINHAND));
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        int leftPos = this.width - 176 >> 1;
        int topPos = this.height - 144 >> 1;
        int i = 0;
        for (Map.Entry<Object2IntMap.Entry<Holder<Enchantment>>, Boolean> entry : this.enchantmentsEntrySet()) {
            Registry access;
            ResourceLocation id;
            ClientLevel level1;
            Object2IntMap.Entry<Holder<Enchantment>> subEntry = entry.getKey();
            Holder holder = (Holder)subEntry.getKey();
            int level = subEntry.getIntValue();
            assert (Minecraft.getInstance().player != null);
            int group = ((ItemEnchantments)Minecraft.getInstance().player.getMainHandItem().getOrDefault(RegisterDataComponents.ENCHANTMENT_GROUPS, (Object)ItemEnchantments.EMPTY)).getLevel(holder);
            if (level <= 0) continue;
            boolean hovered = mouseX >= (double)(leftPos + 130) && mouseX < (double)(leftPos + 152) && mouseY >= (double)(topPos + i * 12 + 19 - 2) && mouseY < (double)(topPos + i * 12 + 19 + 10);
            ++i;
            if (!hovered || (level1 = Minecraft.getInstance().level) == null || (id = (access = level1.registryAccess().lookupOrThrow(Registries.ENCHANTMENT)).getKey((Object)((Enchantment)holder.value()))) == null) continue;
            TEServices.PLATFORM.send2S(new ChangeGroupPacket(id, (int)Math.clamp((double)group + scrollY, 0.0, 9.0)));
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    private Set<Map.Entry<Object2IntMap.Entry<Holder<Enchantment>>, Boolean>> enchantmentsEntrySet() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            this.onClose();
            return new HashSet<Map.Entry<Object2IntMap.Entry<Holder<Enchantment>>, Boolean>>();
        }
        ItemStack stack = player.getMainHandItem();
        if (stack.isEmpty()) {
            this.onClose();
        }
        ItemEnchantments enabled = stack.getEnchantments();
        ItemEnchantments disabled = (ItemEnchantments)stack.getOrDefault(RegisterDataComponents.DISABLED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        HashMap map = new HashMap();
        enabled.entrySet().forEach(e -> map.put(e, true));
        disabled.entrySet().forEach(e -> map.put(e, false));
        return map.entrySet().stream().sorted(Comparator.comparing(e -> ((Holder)((Object2IntMap.Entry)e.getKey()).getKey()).getRegisteredName())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public boolean isPauseScreen() {
        return false;
    }
}

