/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.repackaged.registry;

import java.util.List;
import net.liukrast.deployer.lib.logistics.board.PanelBlockItem;
import net.liukrast.deployer.lib.logistics.packager.CustomPackageStyle;
import net.liukrast.deployer.lib.logistics.packager.GenericPackageItem;
import net.liukrast.repackaged.registry.RepackagedPackageStyles;
import net.liukrast.repackaged.registry.RepackagedPanels;
import net.liukrast.repackaged.registry.RepackagedStockInventoryTypes;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class RepackagedItems {
    protected static final DeferredRegister.Items REGISTER = DeferredRegister.Items.createItems((String)"repackaged");
    public static final List<DeferredItem<GenericPackageItem>> STANDARD_BOTTLES;
    public static final List<DeferredItem<GenericPackageItem>> STANDARD_BATTERIES;
    public static final List<DeferredItem<GenericPackageItem>> RARE_BOTTLES;
    public static final List<DeferredItem<GenericPackageItem>> RARE_BATTERIES;
    public static final DeferredItem<PanelBlockItem> FLUID_GAUGE;

    private RepackagedItems() {
    }

    public static void register(IEventBus eventBus) {
        REGISTER.register(eventBus);
    }

    static {
        FLUID_GAUGE = REGISTER.register("fluid_gauge", () -> new PanelBlockItem(() -> RepackagedPanels.FLUID.get(), new Item.Properties()));
        STANDARD_BOTTLES = RepackagedPackageStyles.BOTTLE_STYLES.stream().filter(style -> !style.rare()).map(style -> REGISTER.register(style.getItemId().getPath(), () -> new GenericPackageItem(new Item.Properties().stacksTo(1), style, () -> RepackagedStockInventoryTypes.FLUID.get(), "item.repackaged.bottle"))).toList();
        STANDARD_BATTERIES = RepackagedPackageStyles.BATTERY_STYLES.stream().filter(style -> !style.rare()).map(style -> REGISTER.register(style.getItemId().getPath(), () -> new GenericPackageItem(new Item.Properties().stacksTo(1), style, () -> RepackagedStockInventoryTypes.ENERGY.get(), "item.repackaged.battery"))).toList();
        RARE_BOTTLES = RepackagedPackageStyles.BOTTLE_STYLES.stream().filter(CustomPackageStyle::rare).map(style -> REGISTER.register(style.getItemId().getPath(), () -> new GenericPackageItem(new Item.Properties().stacksTo(1), style, () -> RepackagedStockInventoryTypes.FLUID.get(), "item.repackaged.rare_bottle"))).toList();
        RARE_BATTERIES = RepackagedPackageStyles.BATTERY_STYLES.stream().filter(CustomPackageStyle::rare).map(style -> REGISTER.register(style.getItemId().getPath(), () -> new GenericPackageItem(new Item.Properties().stacksTo(1), style, () -> RepackagedStockInventoryTypes.ENERGY.get(), "item.repackaged.rare_battery"))).toList();
    }
}

