/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.repackaged.content.energy;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.serialization.Codec;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import java.util.List;
import java.util.Random;
import net.liukrast.deployer.lib.logistics.GenericPackageOrderData;
import net.liukrast.deployer.lib.logistics.packager.AbstractInventorySummary;
import net.liukrast.deployer.lib.logistics.packager.GenericPackageItem;
import net.liukrast.deployer.lib.logistics.packager.StockInventoryType;
import net.liukrast.deployer.lib.logistics.packagerLink.GenericRequestPromise;
import net.liukrast.deployer.lib.logistics.stockTicker.GenericOrderContained;
import net.liukrast.repackaged.RepackagedConstants;
import net.liukrast.repackaged.content.energy.Energy;
import net.liukrast.repackaged.content.energy.EnergyInventorySummary;
import net.liukrast.repackaged.content.energy.EnergyStack;
import net.liukrast.repackaged.registry.RepackagedDataComponents;
import net.liukrast.repackaged.registry.RepackagedItems;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyStockInventoryType
extends StockInventoryType<Energy, EnergyStack, IEnergyStorage> {
    private static final Codec<GenericRequestPromise<EnergyStack>> REQUEST_CODEC = GenericRequestPromise.simpleCodec(EnergyStack.CODEC);
    public static final int MAX_BATTERY_ENERGY = 500000;
    private static final StockInventoryType.IValueHandler<Energy, EnergyStack, IEnergyStorage> VALUE_HANDLER = new StockInventoryType.IValueHandler<Energy, EnergyStack, IEnergyStorage>(EnergyStack.CODEC, EnergyStack.STREAM_CODEC){

        public Energy fromValue(EnergyStack key) {
            return Energy.INSTANCE;
        }

        public boolean equalsIgnoreCount(EnergyStack a, EnergyStack b) {
            return true;
        }

        public boolean test(FilterItemStack filter, Level level, EnergyStack value) {
            return true;
        }

        public int getCount(EnergyStack value) {
            return value.getAmount();
        }

        public void setCount(EnergyStack value, int count) {
            value.setAmount(count);
        }

        public boolean isEmpty(EnergyStack stack) {
            return stack.isEmpty();
        }

        public EnergyStack create(Energy key, int amount) {
            return new EnergyStack(amount);
        }

        public void shrink(EnergyStack stack, int amount) {
            stack.setAmount(stack.getAmount() - amount);
        }

        public EnergyStack copyWithCount(EnergyStack stack, int amount) {
            return new EnergyStack(amount);
        }

        public EnergyStack copy(EnergyStack stack) {
            return new EnergyStack(stack.getAmount());
        }

        public boolean isStackable(EnergyStack stack) {
            return true;
        }

        public EnergyStack empty() {
            return EnergyStack.EMPTY;
        }
    };
    private static final StockInventoryType.IStorageHandler<Energy, EnergyStack, IEnergyStorage> STORAGE_HANDLER = new StockInventoryType.IStorageHandler<Energy, EnergyStack, IEnergyStorage>(){

        public int getSlots(IEnergyStorage handler) {
            return 1;
        }

        public EnergyStack getStackInSlot(IEnergyStorage handler, int slot) {
            return new EnergyStack(handler.getEnergyStored());
        }

        public int maxCountPerSlot() {
            return 500000;
        }

        public EnergyStack extract(IEnergyStorage handler, EnergyStack value, boolean simulate) {
            if (!handler.canExtract()) {
                return EnergyStack.EMPTY;
            }
            return new EnergyStack(handler.extractEnergy(value.getAmount(), simulate));
        }

        public int fill(IEnergyStorage handler, EnergyStack value, boolean simulate) {
            if (!handler.canReceive()) {
                return 0;
            }
            return value.getAmount() - handler.receiveEnergy(value.getAmount(), simulate);
        }

        public EnergyStack setInSlot(IEnergyStorage handler, int slot, EnergyStack value, boolean simulate) {
            int result = this.fill(handler, value, simulate);
            return new EnergyStack(result);
        }

        public boolean isBulky(Energy key) {
            return false;
        }

        public IEnergyStorage create(int i) {
            return new EnergyStorage(500000);
        }

        public int getMaxPackageSlots() {
            return 1;
        }

        public EnergyStack insertItem(IEnergyStorage handler, int i, EnergyStack stack, boolean simulate) {
            if (!handler.canReceive()) {
                return EnergyStack.EMPTY;
            }
            return new EnergyStack(stack.getAmount() - handler.receiveEnergy(stack.getAmount(), simulate));
        }
    };
    private static final StockInventoryType.INetworkHandler<Energy, EnergyStack, IEnergyStorage> NETWORK_HANDLER = new StockInventoryType.INetworkHandler<Energy, EnergyStack, IEnergyStorage>(){

        public Codec<GenericRequestPromise<EnergyStack>> requestCodec() {
            return REQUEST_CODEC;
        }

        public AbstractInventorySummary<Energy, EnergyStack> createSummary() {
            return new EnergyInventorySummary();
        }

        public AbstractInventorySummary<Energy, EnergyStack> empty() {
            return (AbstractInventorySummary)EnergyInventorySummary.EMPTY.get();
        }

        public DataComponentType<? super GenericPackageOrderData<EnergyStack>> getComponent() {
            return (DataComponentType)RepackagedDataComponents.BATTERY_ORDER_DATA.get();
        }
    };
    private static final StockInventoryType.IPackageHandler<Energy, EnergyStack, IEnergyStorage> PACKAGE_HANDLER = new StockInventoryType.IPackageHandler<Energy, EnergyStack, IEnergyStorage>(){
        private static final Random STYLE_PICKER = new Random();
        private static final int RARE_CHANCE = 7500;
        private static final ResourceLocation TEXTURE = RepackagedConstants.id("textures/gui/energy_stock_inventory.png", new Object[0]);
        private static final Component ACTION_REMOVE = Component.translatable((String)"stock_inventory_type.repackaged.energy.action_remove");
        private static final Component ACTION_ADD = Component.translatable((String)"stock_inventory_type.repackaged.energy.action_add");

        public void setBoxContent(ItemStack stack, IEnergyStorage inventory) {
            stack.set(RepackagedDataComponents.BATTERY_CONTENTS, (Object)inventory.getEnergyStored());
        }

        public ItemStack getRandomBox() {
            List<DeferredItem<GenericPackageItem>> pool = STYLE_PICKER.nextInt(7500) == 0 ? RepackagedItems.RARE_BATTERIES : RepackagedItems.STANDARD_BATTERIES;
            return new ItemStack((ItemLike)pool.get(STYLE_PICKER.nextInt(pool.size())).get());
        }

        public IEnergyStorage getContents(ItemStack box) {
            return (IEnergyStorage)box.getCapability(Capabilities.EnergyStorage.ITEM);
        }

        public DataComponentType<GenericPackageOrderData<EnergyStack>> packageOrderData() {
            return (DataComponentType)RepackagedDataComponents.BATTERY_ORDER_DATA.get();
        }

        public DataComponentType<GenericOrderContained<EnergyStack>> packageOrderContext() {
            return (DataComponentType)RepackagedDataComponents.BATTERY_ORDER_CONTEXT.get();
        }

        public int clickAmount(boolean ctrlDown, boolean shiftDown, boolean altDown) {
            return ctrlDown ? 100 : (shiftDown ? 1000 : (altDown ? 1 : 10));
        }

        public int scrollAmount(boolean ctrlDown, boolean shiftDown, boolean altDown) {
            return ctrlDown ? 100 : (shiftDown ? 1000 : (altDown ? 1 : 10));
        }

        public boolean shouldRenderSearchBar() {
            return false;
        }

        public boolean matchesModSearch(EnergyStack stack, String searchValue) {
            return true;
        }

        public boolean matchesTagSearch(EnergyStack stack, String searchValue) {
            return true;
        }

        public boolean matchesSearch(EnergyStack stack, String searchValue) {
            return true;
        }

        public void renderCategory(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY, List<EnergyStack> categoryStacks, List<EnergyStack> itemsToOrder, AbstractInventorySummary<Energy, EnergyStack> forcedEntries, StockInventoryType.CategoryRenderData data) {
            EnergyStack order;
            if (categoryStacks.isEmpty()) {
                return;
            }
            graphics.blit(TEXTURE, data.itemsX(), data.itemsY(), 32, 48, 192, 128);
            EnergyStack entry = categoryStacks.getFirst();
            int customCount = entry.getAmount();
            EnergyStack energyStack = order = itemsToOrder.isEmpty() ? null : itemsToOrder.getFirst();
            if (entry.getAmount() < 1000000000) {
                int forcedCount = forcedEntries.getCountOf((Object)entry);
                if (forcedCount != 0) {
                    customCount = Math.min(customCount, -forcedCount - 1);
                }
                if (order != null) {
                    customCount -= order.getAmount();
                }
                customCount = Math.max(0, customCount);
            }
            this.drawCount(graphics, customCount, data.itemsX() + 144, data.itemsY() + 41);
        }

        public void renderOrderedItems(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY, List<EnergyStack> itemsToOrder, AbstractInventorySummary<Energy, EnergyStack> forcedEntries, StockInventoryType.OrderRenderData data) {
            graphics.blit(TEXTURE, data.itemsX() - 39, data.orderY() - 8, 0, 0, 256, 48);
            if (itemsToOrder.isEmpty()) {
                return;
            }
            int amountON176 = Math.min(itemsToOrder.getFirst().getAmount() * 176 / 500000, 176);
            graphics.blit(TEXTURE, data.itemsX() + 1 + 176 - amountON176, data.orderY() + 1, 40, 185, amountON176, 17);
            this.drawCount(graphics, itemsToOrder.getFirst().getAmount(), data.itemsX() + 160, data.orderY() + 7);
        }

        private void drawCount(GuiGraphics graphics, int customCount, int x, int y) {
            Object text;
            Object object = customCount >= 1000000 ? customCount / 1000000 + "m" : (customCount >= 10000 ? customCount / 1000 + "k" : (customCount >= 1000 ? (float)(customCount * 10 / 1000) / 10.0f + "k" : (text = customCount >= 100 ? "" + customCount : " " + customCount)));
            if (customCount >= 1000000000) {
                text = "+";
            }
            if (((String)(text = (String)text + "\u26a1")).isBlank()) {
                return;
            }
            int totalW = 0;
            for (char c : ((String)text).toCharArray()) {
                int w = switch (c) {
                    case '.' -> 3;
                    case 'm', '\u26a1' -> 7;
                    case '+' -> 9;
                    default -> 5;
                };
                totalW += w - 1;
            }
            int x0 = 0;
            for (char c : ((String)text).toCharArray()) {
                int w = switch (c) {
                    case '.' -> 3;
                    case 'm', '\u26a1' -> 7;
                    case '+' -> 9;
                    default -> 5;
                };
                int p = switch (c) {
                    case 'k' -> 64;
                    case 'm' -> 70;
                    case 'b' -> 78;
                    case '+' -> 84;
                    case '\u26a1' -> 94;
                    default -> (c - 48) * 6;
                };
                RenderSystem.enableBlend();
                graphics.blit(TEXTURE, x0 + x - totalW / 2, y, 48 + p, 209, w, 7);
                x0 += w - 1;
            }
        }

        public void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, EnergyStack entry, Font font, boolean isOrder) {
            graphics.renderTooltip(font, isOrder ? ACTION_REMOVE : ACTION_ADD, mouseX, mouseY);
        }

        public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltipComponents, TooltipFlag tooltipFlag, IEnergyStorage handler) {
            tooltipComponents.add((Component)Component.literal((String)(handler.getEnergyStored() + "\u26a1")).withStyle(ChatFormatting.GRAY));
        }

        public int getColWidth() {
            return 180;
        }

        public int getRowHeight() {
            return 80;
        }
    };
    private static final ItemStack ICON = Items.LIGHTNING_ROD.getDefaultInstance();

    @NotNull
    public StockInventoryType.IValueHandler<Energy, EnergyStack, IEnergyStorage> valueHandler() {
        return VALUE_HANDLER;
    }

    @NotNull
    public StockInventoryType.IStorageHandler<Energy, EnergyStack, IEnergyStorage> storageHandler() {
        return STORAGE_HANDLER;
    }

    @NotNull
    public StockInventoryType.INetworkHandler<Energy, EnergyStack, IEnergyStorage> networkHandler() {
        return NETWORK_HANDLER;
    }

    @NotNull
    public StockInventoryType.IPackageHandler<Energy, EnergyStack, IEnergyStorage> packageHandler() {
        return PACKAGE_HANDLER;
    }

    @NotNull
    public ItemStack getIcon() {
        return ICON;
    }

    public BlockCapability<IEnergyStorage, @Nullable Direction> getBlockCapability() {
        return Capabilities.EnergyStorage.BLOCK;
    }
}

