/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.repackaged;

import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepackagedConstants {
    public static final String MOD_ID = "repackaged";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"repackaged");

    private RepackagedConstants() {
    }

    public static ResourceLocation id(String path, Object ... args) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)String.format(path, args));
    }

    public static <T> DeferredRegister<T> createDeferred(Registry<T> registry) {
        return DeferredRegister.create(registry, (String)MOD_ID);
    }

    public static <T> Stream<T> getElements(Registry<T> registry) {
        return RepackagedConstants.getElementEntries(registry).map(Map.Entry::getValue);
    }

    public static <T> Stream<Map.Entry<String, T>> getElementEntries(Registry<T> registry) {
        return registry.entrySet().stream().filter(t -> ((ResourceKey)t.getKey()).location().getNamespace().equals(MOD_ID)).map(e -> Map.entry(((ResourceKey)e.getKey()).location().getPath(), e.getValue()));
    }

    public static <T> ResourceKey<T> registerKey(ResourceKey<? extends Registry<T>> registry, String name) {
        return ResourceKey.create(registry, (ResourceLocation)RepackagedConstants.id(name, new Object[0]));
    }
}

