/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.repackaged.content.fluid;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.Codec;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.liukrast.deployer.lib.helper.GuiRenderingHelper;
import net.liukrast.deployer.lib.logistics.GenericPackageOrderData;
import net.liukrast.deployer.lib.logistics.packager.AbstractInventorySummary;
import net.liukrast.deployer.lib.logistics.packager.GenericPackageItem;
import net.liukrast.deployer.lib.logistics.packager.StockInventoryType;
import net.liukrast.deployer.lib.logistics.packagerLink.GenericRequestPromise;
import net.liukrast.deployer.lib.logistics.stockTicker.GenericOrderContained;
import net.liukrast.repackaged.RepackagedConstants;
import net.liukrast.repackaged.content.fluid.FluidInventorySummary;
import net.liukrast.repackaged.registry.RepackagedDataComponents;
import net.liukrast.repackaged.registry.RepackagedItems;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidStockInventoryType
extends StockInventoryType<Fluid, FluidStack, IFluidHandler> {
    private static final Codec<GenericRequestPromise<FluidStack>> REQUEST_CODEC = GenericRequestPromise.simpleCodec((Codec)FluidStack.CODEC);
    private static final StockInventoryType.IValueHandler<Fluid, FluidStack, IFluidHandler> VALUE_HANDLER = new StockInventoryType.IValueHandler<Fluid, FluidStack, IFluidHandler>(FluidStack.CODEC, FluidStack.STREAM_CODEC){

        public Fluid fromValue(FluidStack key) {
            return key.getFluid();
        }

        public boolean equalsIgnoreCount(FluidStack a, FluidStack b) {
            return FluidStack.isSameFluidSameComponents((FluidStack)a, (FluidStack)b);
        }

        public boolean test(FilterItemStack filter, Level level, FluidStack value) {
            return filter.test(level, value);
        }

        public int getCount(FluidStack value) {
            return value.getAmount();
        }

        public void setCount(FluidStack value, int count) {
            value.setAmount(count);
        }

        public boolean isEmpty(FluidStack stack) {
            return stack.isEmpty();
        }

        public FluidStack create(Fluid key, int amount) {
            return new FluidStack(key, amount);
        }

        public void shrink(FluidStack stack, int amount) {
            stack.shrink(amount);
        }

        public FluidStack copyWithCount(FluidStack stack, int amount) {
            return stack.copyWithAmount(amount);
        }

        public FluidStack copy(FluidStack stack) {
            return stack.copy();
        }

        public boolean isStackable(FluidStack stack) {
            return true;
        }

        public FluidStack empty() {
            return FluidStack.EMPTY;
        }
    };
    private static final StockInventoryType.IStorageHandler<Fluid, FluidStack, IFluidHandler> STORAGE_HANDLER = new StockInventoryType.IStorageHandler<Fluid, FluidStack, IFluidHandler>(){

        public int getSlots(IFluidHandler handler) {
            return handler.getTanks();
        }

        public FluidStack getStackInSlot(IFluidHandler handler, int slot) {
            return handler.getFluidInTank(slot);
        }

        public int maxCountPerSlot() {
            return 1000;
        }

        public FluidStack extract(IFluidHandler handler, FluidStack value, boolean simulate) {
            return handler.drain(value, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
        }

        public int fill(IFluidHandler handler, FluidStack stack, boolean simulate) {
            return stack.getAmount() - handler.fill(stack.copy(), simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
        }

        public FluidStack setInSlot(IFluidHandler handler, int slot, FluidStack value, boolean simulate) {
            int result = this.fill(handler, value, simulate);
            return new FluidStack(value.getFluid(), result);
        }

        public boolean isBulky(Fluid key) {
            return false;
        }

        public IFluidHandler create(int slots) {
            return new FluidTank(1000);
        }

        public int getMaxPackageSlots() {
            return 1;
        }

        public FluidStack insertItem(IFluidHandler handler, int i, FluidStack value, boolean simulate) {
            return new FluidStack(value.getFluid(), this.fill(handler, value, simulate));
        }
    };
    private static final StockInventoryType.INetworkHandler<Fluid, FluidStack, IFluidHandler> NETWORK_HANDLER = new StockInventoryType.INetworkHandler<Fluid, FluidStack, IFluidHandler>(){

        public Codec<GenericRequestPromise<FluidStack>> requestCodec() {
            return REQUEST_CODEC;
        }

        public AbstractInventorySummary<Fluid, FluidStack> createSummary() {
            return new FluidInventorySummary();
        }

        public AbstractInventorySummary<Fluid, FluidStack> empty() {
            return (AbstractInventorySummary)FluidInventorySummary.EMPTY.get();
        }

        public DataComponentType<? super GenericPackageOrderData<FluidStack>> getComponent() {
            return (DataComponentType)RepackagedDataComponents.BOTTLE_ORDER_DATA.get();
        }
    };
    private static final StockInventoryType.IPackageHandler<Fluid, FluidStack, IFluidHandler> PACKAGE_HANDLER = new StockInventoryType.IPackageHandler<Fluid, FluidStack, IFluidHandler>(){
        private static final Random STYLE_PICKER = new Random();
        private static final int RARE_CHANCE = 7500;
        private static final ResourceLocation TEXTURE = RepackagedConstants.id("textures/gui/fluid_stock_inventory.png", new Object[0]);

        public void setBoxContent(ItemStack stack, IFluidHandler inventory) {
            stack.set(RepackagedDataComponents.BOTTLE_CONTENTS, (Object)SimpleFluidContent.copyOf((FluidStack)inventory.getFluidInTank(0)));
        }

        public ItemStack getRandomBox() {
            List<DeferredItem<GenericPackageItem>> pool = STYLE_PICKER.nextInt(7500) == 0 ? RepackagedItems.RARE_BOTTLES : RepackagedItems.STANDARD_BOTTLES;
            return new ItemStack((ItemLike)pool.get(STYLE_PICKER.nextInt(pool.size())).get());
        }

        public IFluidHandler getContents(ItemStack box) {
            FluidTank newInv = new FluidTank(1000);
            SimpleFluidContent contents = (SimpleFluidContent)box.getOrDefault((DataComponentType)RepackagedDataComponents.BOTTLE_CONTENTS.get(), (Object)SimpleFluidContent.EMPTY);
            newInv.fill(contents.copy(), IFluidHandler.FluidAction.EXECUTE);
            return newInv;
        }

        public DataComponentType<GenericPackageOrderData<FluidStack>> packageOrderData() {
            return (DataComponentType)RepackagedDataComponents.BOTTLE_ORDER_DATA.get();
        }

        public DataComponentType<GenericOrderContained<FluidStack>> packageOrderContext() {
            return (DataComponentType)RepackagedDataComponents.BOTTLE_ORDER_CONTEXT.get();
        }

        public int clickAmount(boolean ctrlDown, boolean shiftDown, boolean altDown) {
            return ctrlDown ? 100 : (shiftDown ? 1000 : (altDown ? 1 : 10));
        }

        public int scrollAmount(boolean ctrlDown, boolean shiftDown, boolean altDown) {
            return ctrlDown ? 100 : (shiftDown ? 1000 : (altDown ? 1 : 10));
        }

        public boolean matchesModSearch(FluidStack stack, String searchValue) {
            return BuiltInRegistries.FLUID.getKey((Object)stack.getFluid()).getNamespace().contains(searchValue);
        }

        public boolean matchesTagSearch(FluidStack stack, String searchValue) {
            return stack.getFluid().builtInRegistryHolder().tags().anyMatch(key -> key.location().toString().contains(searchValue));
        }

        public boolean matchesSearch(FluidStack stack, String searchValue) {
            return stack.getHoverName().getString().toLowerCase(Locale.ROOT).contains(searchValue) || BuiltInRegistries.FLUID.getKey((Object)stack.getFluid()).getPath().contains(searchValue);
        }

        public void renderCategory(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY, List<FluidStack> category, List<FluidStack> itemsToOrder, AbstractInventorySummary<Fluid, FluidStack> forcedEntries, StockInventoryType.CategoryRenderData data) {
            for (int index = 0; index < category.size(); ++index) {
                int pY = data.itemsY() + data.categoryY() + (data.categories().isEmpty() ? 4 : data.rowHeight()) + index / data.cols() * data.rowHeight();
                float cullY = (float)pY - data.currentScroll() * (float)data.rowHeight();
                if (cullY < (float)data.y()) continue;
                if (cullY > (float)(data.y() + data.windowHeight() - 72)) break;
                boolean isStackHovered = index == (Integer)data.hoveredSlot().getSecond() && data.categoryIndex() == ((Integer)data.hoveredSlot().getFirst()).intValue();
                FluidStack entry = category.get(index);
                data.ms().pushPose();
                data.ms().translate((float)(data.itemsX() + index % data.cols() * data.colWidth()), (float)pY, 0.0f);
                this.renderFluidEntry(graphics, entry, isStackHovered, false, data.colWidth(), data.rowHeight(), itemsToOrder, forcedEntries);
                data.ms().popPose();
            }
        }

        private void renderFluidEntry(GuiGraphics graphics, FluidStack entry, boolean isStackHovered, boolean isRenderingOrders, int colWidth, int rowHeight, List<FluidStack> itemsToOrder, AbstractInventorySummary<Fluid, FluidStack> forcedEntries) {
            int customCount = entry.getAmount();
            if (!isRenderingOrders) {
                FluidStack order = this.getOrderForFluid(entry, itemsToOrder);
                if (entry.getAmount() < 1000000000) {
                    int forcedCount = forcedEntries.getCountOf((Object)entry);
                    if (forcedCount != 0) {
                        customCount = Math.min(customCount, -forcedCount - 1);
                    }
                    if (order != null) {
                        customCount -= order.getAmount();
                    }
                    customCount = Math.max(0, customCount);
                }
                AllGuiTextures.STOCK_KEEPER_REQUEST_SLOT.render(graphics, 0, 0);
            }
            PoseStack ms = graphics.pose();
            ms.pushPose();
            float scaleFromHover = 1.0f;
            if (isStackHovered) {
                scaleFromHover += 0.075f;
            }
            ms.translate((double)(colWidth - 18) / 2.0, (double)(rowHeight - 18) / 2.0, 0.0);
            ms.translate(9.0, 9.0, 0.0);
            ms.scale(1.0f, 1.0f, 1.0f);
            ms.scale(scaleFromHover, scaleFromHover, scaleFromHover);
            ms.translate(-9.0, -9.0, 0.0);
            if (customCount != 0) {
                GuiRenderingHelper.renderFluid((GuiGraphics)graphics, (FluidStack)entry, (int)0, (int)0, (int)16, (int)16);
            }
            ms.popPose();
            ms.pushPose();
            ms.translate(0.0f, 0.0f, 190.0f);
            ms.translate(0.0f, 0.0f, 10.0f);
            if (customCount > 1) {
                this.drawItemCount(graphics, customCount);
            }
            ms.popPose();
        }

        private FluidStack getOrderForFluid(FluidStack stack, List<FluidStack> itemsToOrder) {
            for (FluidStack entry : itemsToOrder) {
                if (!FluidStack.isSameFluidSameComponents((FluidStack)stack, (FluidStack)entry)) continue;
                return entry;
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void drawItemCount(GuiGraphics graphics, int customCount) {
            Object text;
            Object object = customCount >= 1000000 ? customCount / 1000000 + "m" : (customCount >= 10000 ? customCount / 1000 + "k" : (customCount >= 1000 ? (float)(customCount * 10 / 1000) / 10.0f + "k" : (text = customCount >= 100 ? "" + customCount : " " + customCount)));
            if (customCount >= 1000000000) {
                text = "+";
            }
            if (((String)text).isBlank()) {
                return;
            }
            int x = (int)Math.floor((double)(-((String)text).length()) * 2.5);
            char[] cArray = ((String)text).toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (true) {
                block11: {
                    if (n2 >= n) {
                        return;
                    }
                    char c = cArray[n2];
                    int index = c - 48;
                    int xOffset = index * 6;
                    int spriteWidth = AllGuiTextures.NUMBERS.getWidth();
                    switch (c) {
                        case ' ': {
                            x += 4;
                            break block11;
                        }
                        case '.': {
                            spriteWidth = 3;
                            xOffset = 60;
                            break;
                        }
                        case 'k': {
                            xOffset = 64;
                            break;
                        }
                        case 'm': {
                            spriteWidth = 7;
                            xOffset = 70;
                            break;
                        }
                        case '+': {
                            spriteWidth = 9;
                            xOffset = 84;
                        }
                    }
                    RenderSystem.enableBlend();
                    graphics.blit(AllGuiTextures.NUMBERS.location, 14 + x, 10, 0, (float)(AllGuiTextures.NUMBERS.getStartX() + xOffset), (float)AllGuiTextures.NUMBERS.getStartY(), spriteWidth, AllGuiTextures.NUMBERS.getHeight(), 256, 256);
                    x += spriteWidth - 1;
                }
                ++n2;
            }
        }

        public void renderOrderedItems(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY, List<FluidStack> itemsToOrder, AbstractInventorySummary<Fluid, FluidStack> forcedEntries, StockInventoryType.OrderRenderData data) {
            graphics.blit(TEXTURE, data.itemsX() - 39, data.orderY() - 8, 0, 0, 256, 48);
            PoseStack ms = data.ms();
            for (int index = 0; index < data.cols() && itemsToOrder.size() > index; ++index) {
                FluidStack entry = itemsToOrder.get(index);
                boolean isStackHovered = index == (Integer)data.hoveredSlot().getSecond() && (Integer)data.hoveredSlot().getFirst() == -1;
                ms.pushPose();
                ms.translate((float)(data.itemsX() + index * data.colWidth()), (float)data.orderY(), 0.0f);
                this.renderFluidEntry(graphics, entry, isStackHovered, true, data.colWidth(), data.rowHeight(), itemsToOrder, forcedEntries);
                ms.popPose();
            }
        }

        public void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, FluidStack entry, Font font, boolean isOrder) {
            GuiRenderingHelper.renderTooltip((GuiGraphics)graphics, (FluidStack)entry, (int)mouseX, (int)mouseY, (Font)font);
        }

        public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltipComponents, TooltipFlag tooltipFlag, IFluidHandler handler) {
            int visibleNames = 0;
            int skippedNames = 0;
            for (int i = 0; i < handler.getTanks(); ++i) {
                FluidStack fluidStack = handler.getFluidInTank(i);
                if (fluidStack.isEmpty()) continue;
                if (visibleNames > 2) {
                    ++skippedNames;
                    continue;
                }
                ++visibleNames;
                tooltipComponents.add((Component)fluidStack.getHoverName().copy().append(" x" + fluidStack.getAmount() + "Mb").withStyle(ChatFormatting.GRAY));
            }
            if (skippedNames > 0) {
                tooltipComponents.add((Component)Component.translatable((String)"container.shulkerBox.more", (Object[])new Object[]{skippedNames}).withStyle(ChatFormatting.ITALIC));
            }
        }
    };
    private static final ItemStack ICON = Items.WATER_BUCKET.getDefaultInstance();

    @NotNull
    public StockInventoryType.IValueHandler<Fluid, FluidStack, IFluidHandler> valueHandler() {
        return VALUE_HANDLER;
    }

    @NotNull
    public StockInventoryType.IStorageHandler<Fluid, FluidStack, IFluidHandler> storageHandler() {
        return STORAGE_HANDLER;
    }

    @NotNull
    public StockInventoryType.INetworkHandler<Fluid, FluidStack, IFluidHandler> networkHandler() {
        return NETWORK_HANDLER;
    }

    @NotNull
    public StockInventoryType.IPackageHandler<Fluid, FluidStack, IFluidHandler> packageHandler() {
        return PACKAGE_HANDLER;
    }

    @NotNull
    public ItemStack getIcon() {
        return ICON;
    }

    public BlockCapability<IFluidHandler, @Nullable Direction> getBlockCapability() {
        return Capabilities.FluidHandler.BLOCK;
    }
}

