/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.multipart.block;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.liukrast.multipart.MultipartAPI;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMultipartBlock
extends Block {
    private List<BlockPos> positions;
    private IntegerProperty property;

    public AbstractMultipartBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)this.property, (Comparable)Integer.valueOf(0)));
    }

    public abstract void defineParts(Builder var1);

    public Direction getDirection(BlockState state) {
        return Direction.NORTH;
    }

    public IntegerProperty getPartsProperty() {
        return this.property;
    }

    public void setPlacedBy(@NotNull Level level, BlockPos pos, @NotNull BlockState state, LivingEntity placer, @NotNull ItemStack stack) {
        Direction direction = this.getDirection(state);
        BlockPos statePos = this.positions.get((Integer)state.getValue((Property)this.property));
        BlockPos origin = pos.relative(direction, statePos.getZ()).relative(Direction.UP, -statePos.getY()).relative(direction.getCounterClockWise(), -statePos.getX());
        for (int i = 0; i < this.positions.size(); ++i) {
            BlockPos pos1 = this.positions.get(i);
            level.setBlock(origin.relative(direction, -pos1.getZ()).relative(Direction.UP, pos1.getY()).relative(direction.getCounterClockWise(), pos1.getX()), (BlockState)state.setValue((Property)this.property, (Comparable)Integer.valueOf(i)), 3);
        }
    }

    public BlockPos getOrigin(BlockPos pos, BlockPos statePos, Direction direction) {
        return pos.relative(direction, statePos.getZ()).relative(Direction.UP, -statePos.getY()).relative(direction.getCounterClockWise(), -statePos.getX());
    }

    public BlockPos getRelative(BlockPos pos, BlockPos statePos, Direction direction) {
        return pos.relative(direction, -statePos.getZ()).relative(Direction.UP, statePos.getY()).relative(direction.getCounterClockWise(), statePos.getX());
    }

    public void forEachElement(BlockPos pos, BlockState state, Consumer<BlockPos> consumer) {
        Direction direction = this.getDirection(state);
        BlockPos statePos = this.positions.get((Integer)state.getValue((Property)this.property));
        BlockPos origin = this.getOrigin(pos, statePos, direction);
        for (BlockPos temp : this.positions) {
            consumer.accept(this.getRelative(origin, temp, direction));
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        Builder builder1 = new Builder();
        this.defineParts(builder1);
        this.positions = builder1.build();
        this.property = IntegerProperty.create((String)"part", (int)0, (int)(this.positions.size() - 1));
        builder.add(new Property[]{this.property});
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        Direction direction = this.getDirection(state);
        BlockPos statePos = this.positions.get((Integer)state.getValue((Property)this.property));
        BlockPos origin = this.getOrigin(pos, statePos, direction);
        boolean bl = true;
        for (BlockPos temp : this.positions) {
            BlockPos pos1 = this.getRelative(origin, temp, direction);
            BlockState state1 = level.getBlockState(pos1);
            if (state1.canBeReplaced()) continue;
            if (level.isClientSide()) {
                MultipartAPI.notify(pos1);
            }
            bl = false;
        }
        return bl;
    }

    public void destroy(@NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Direction direction = this.getDirection(state);
        BlockPos statePos = this.positions.get((Integer)state.getValue((Property)this.property));
        BlockPos origin = this.getOrigin(pos, statePos, direction);
        for (BlockPos temp : this.positions) {
            BlockPos pos1 = this.getRelative(origin, temp, direction);
            level.destroyBlock(pos1, false);
        }
    }

    public int size() {
        return this.positions.size();
    }

    public static class Builder {
        private final List<BlockPos> positions = new ArrayList<BlockPos>();

        private Builder() {
        }

        public Builder define(int x, int y, int z) {
            BlockPos pos = new BlockPos(x, y, z);
            if (this.positions.contains(pos)) {
                throw new IllegalCallerException(String.format("Position [%s, %s, %s] is already defined", x, y, z));
            }
            this.positions.add(pos);
            return this;
        }

        private List<BlockPos> build() {
            if (this.positions.isEmpty()) {
                throw new IllegalStateException("The multipart builder should not be empty");
            }
            return ImmutableList.copyOf(this.positions);
        }
    }
}

