/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.multipart;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.util.InternalApi;

public class MultipartAPI {
    private static final LinkedHashMap<BlockPos, Integer> stored = new LinkedHashMap();

    private MultipartAPI() {
    }

    public static void notify(BlockPos pos) {
        stored.put(pos, 60);
    }

    @InternalApi
    public static void render(PoseStack poseStack) {
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        Vec3 camPos = camera.getPosition();
        for (BlockPos pos : stored.keySet()) {
            AABB box = AABB.ofSize((Vec3)Vec3.atCenterOf((Vec3i)pos), (double)1.0, (double)1.0, (double)1.0).move(-camPos.x, -camPos.y, -camPos.z);
            LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(RenderType.lines()), (AABB)box, (float)1.0f, (float)0.0f, (float)0.0f, (float)((float)stored.get(pos).intValue() / 60.0f));
        }
    }

    @InternalApi
    public static void tick() {
        for (BlockPos pos : new ArrayList<BlockPos>(stored.keySet())) {
            int value = stored.get(pos);
            if (value <= 0) {
                stored.remove(pos);
                continue;
            }
            stored.put(pos, value - 1);
        }
    }
}

