/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.mixin;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Definitions;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Cancellable;
import com.llamalad7.mixinextras.sugar.Local;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBlockItem;
import java.util.Map;
import javax.annotation.Nullable;
import net.liukrast.eg.api.logistics.board.AbstractPanelBehaviour;
import net.liukrast.eg.api.logistics.board.PanelConnections;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FactoryPanelBehaviour.class})
public abstract class FactoryPanelBehaviourMixin {
    @Shadow
    public Map<FactoryPanelPosition, FactoryPanelConnection> targetedBy;
    @Shadow
    public boolean active;

    @Shadow
    @Nullable
    public static FactoryPanelBehaviour at(BlockAndTintGetter world, FactoryPanelConnection connection) {
        throw new AssertionError((Object)"Mixin injection failed");
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/foundation/blockEntity/behaviour/filtering/FilteringBehaviour;tick()V", shift=At.Shift.AFTER)}, cancellable=true)
    private void tick(CallbackInfo ci) {
        if (FactoryPanelBehaviour.class.cast(this) instanceof AbstractPanelBehaviour) {
            ci.cancel();
        }
    }

    @WrapOperation(method={"at(Lnet/minecraft/world/level/BlockAndTintGetter;Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelPosition;)Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelBehaviour;"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definitions(value={@Definition(id="behaviour", local={@Local(type=FactoryPanelBehaviour.class)}), @Definition(id="active", field={"Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelBehaviour;active:Z"})})
    @Expression(value={"behaviour.active"})
    private static boolean at(FactoryPanelBehaviour instance, Operation<Boolean> original) {
        if (instance == null) {
            return true;
        }
        return (Boolean)original.call(new Object[]{instance});
    }

    @ModifyVariable(method={"moveTo"}, at=@At(value="STORE", ordinal=0))
    private FactoryPanelBehaviour moveTo(FactoryPanelBehaviour original) {
        FactoryPanelBlockEntity be = (FactoryPanelBlockEntity)original.blockEntity;
        FactoryPanelBlock.PanelSlot slot = original.slot;
        Object v = be.panels.get(slot);
        if (v instanceof AbstractPanelBehaviour) {
            AbstractPanelBehaviour superOriginal = (AbstractPanelBehaviour)((Object)v);
            return superOriginal.getPanelType().create(be, slot);
        }
        return original;
    }

    @WrapWithCondition(method={"tickRequests"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelBehaviour;sendEffect(Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelPosition;Z)V")})
    private boolean tickRequests(FactoryPanelBehaviour instance, FactoryPanelPosition factoryPanelPosition, boolean fromPos) {
        AbstractPanelBehaviour ab;
        return !(instance instanceof AbstractPanelBehaviour) || (ab = (AbstractPanelBehaviour)instance).hasConnection(PanelConnections.FILTER);
    }

    @ModifyExpressionValue(method={"tickRequests"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definition(id="failed", local={@Local(type=boolean.class)})
    @Expression(value={"failed = @(true)"})
    private int tickRequests$1(int original) {
        AbstractPanelBehaviour ab;
        FactoryPanelBehaviour instance = (FactoryPanelBehaviour)FactoryPanelBehaviour.class.cast(this);
        return !(instance instanceof AbstractPanelBehaviour) || (ab = (AbstractPanelBehaviour)instance).hasConnection(PanelConnections.FILTER) ? 1 : 0;
    }

    @ModifyVariable(method={"checkForRedstoneInput"}, at=@At(value="STORE"))
    private boolean checkForRedstoneInput(boolean shouldPower, @Cancellable CallbackInfo ci) {
        FactoryPanelBehaviour i = (FactoryPanelBehaviour)FactoryPanelBehaviour.class.cast(this);
        for (FactoryPanelConnection connection : this.targetedBy.values()) {
            if (!i.getWorld().isLoaded(connection.from.pos())) {
                ci.cancel();
                return false;
            }
            FactoryPanelBehaviour behaviour = FactoryPanelBehaviourMixin.at((BlockAndTintGetter)i.getWorld(), connection);
            if (behaviour == null || !behaviour.isActive() || !(behaviour instanceof AbstractPanelBehaviour)) {
                ci.cancel();
                return false;
            }
            AbstractPanelBehaviour panel = (AbstractPanelBehaviour)behaviour;
            if (!panel.hasConnection(PanelConnections.REDSTONE)) continue;
            if (panel.hasConnection(PanelConnections.FILTER)) {
                if (!panel.shouldUseRedstoneInsteadOfFilter()) continue;
                shouldPower |= panel.getConnectionValue(PanelConnections.REDSTONE).orElse(0) > 0;
                continue;
            }
            shouldPower |= panel.getConnectionValue(PanelConnections.REDSTONE).orElse(0) > 0;
        }
        return shouldPower;
    }

    @ModifyExpressionValue(method={"onShortInteract"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEmpty()Z", ordinal=0)})
    private boolean onShortInteract(boolean original) {
        AbstractPanelBehaviour panel;
        FactoryPanelBehaviour instance = (FactoryPanelBehaviour)FactoryPanelBehaviour.class.cast(this);
        return instance instanceof AbstractPanelBehaviour ? (panel = (AbstractPanelBehaviour)instance).shouldAllowFilteringBehaviour() && original : original;
    }

    @ModifyExpressionValue(method={"onShortInteract"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definitions(value={@Definition(id="heldItem", local={@Local(type=ItemStack.class)}), @Definition(id="getItem", method={"Lnet/minecraft/world/item/ItemStack;getItem()Lnet/minecraft/world/item/Item;"}), @Definition(id="LogisticallyLinkedBlockItem", type={LogisticallyLinkedBlockItem.class})})
    @Expression(value={"heldItem.getItem() instanceof LogisticallyLinkedBlockItem"})
    private boolean onShortInteract$1(boolean original) {
        FactoryPanelBehaviour instance = (FactoryPanelBehaviour)FactoryPanelBehaviour.class.cast(this);
        return original && !(instance instanceof AbstractPanelBehaviour);
    }
}

