/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.content.logistics.board;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelSupportBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.List;
import java.util.Optional;
import net.liukrast.eg.api.logistics.board.AbstractPanelBehaviour;
import net.liukrast.eg.api.logistics.board.PanelConnections;
import net.liukrast.eg.api.registry.PanelType;
import net.liukrast.eg.content.logistics.board.NumericalScrollPanelBehaviour;
import net.liukrast.eg.registry.RegisterItems;
import net.liukrast.eg.registry.RegisterPartialModels;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.BlockHitResult;

public class CounterPanelBehaviour
extends NumericalScrollPanelBehaviour {
    private boolean power;

    public CounterPanelBehaviour(PanelType<?> type, FactoryPanelBlockEntity be, FactoryPanelBlock.PanelSlot slot) {
        super((Component)Component.translatable((String)"create.logistics.counter_threshold"), type, be, slot);
        this.between(0, 256);
    }

    public ValueSettingsBoard createBoard(Player player, BlockHitResult hitResult) {
        ImmutableList rows = ImmutableList.of((Object)Component.literal((String)"Positive").withStyle(ChatFormatting.BOLD));
        ValueSettingsFormatter formatter = new ValueSettingsFormatter(this::formatSettings);
        return new ValueSettingsBoard(this.label, 256, 32, (List)rows, formatter);
    }

    @Override
    public void setValueSettings(Player player, ValueSettingsBehaviour.ValueSettings valueSetting, boolean ctrlHeld) {
        int value = valueSetting.value();
        if (!valueSetting.equals((Object)this.getValueSettings())) {
            this.playFeedbackSound((BlockEntityBehaviour)this);
        }
        this.setValue(value);
    }

    @Override
    public void easyWrite(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        super.easyWrite(nbt, registries, clientPacket);
        nbt.putInt("Count", this.count);
        nbt.putBoolean("Power", this.power);
    }

    @Override
    public void easyRead(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        super.easyRead(nbt, registries, clientPacket);
        this.count = nbt.getInt("Count");
        this.power = nbt.getBoolean("Power");
    }

    @Override
    public void addConnections(AbstractPanelBehaviour.PanelConnectionBuilder builder) {
        builder.put(PanelConnections.INTEGER, () -> this.count);
        builder.put(PanelConnections.REDSTONE, () -> this.count >= this.value ? 15 : 0);
    }

    @Override
    public Item getItem() {
        return RegisterItems.COUNTER_GAUGE.asItem();
    }

    @Override
    public PartialModel getModel(FactoryPanelBlock.PanelState panelState, FactoryPanelBlock.PanelType panelType) {
        return RegisterPartialModels.COUNTER_PANEL;
    }

    public void checkForRedstoneInput() {
        if (!this.active) {
            return;
        }
        boolean shouldPower = false;
        for (FactoryPanelConnection connection : this.targetedByLinks.values()) {
            if (!this.getWorld().isLoaded(connection.from.pos())) {
                return;
            }
            FactoryPanelSupportBehaviour linkAt = CounterPanelBehaviour.linkAt((BlockAndTintGetter)this.getWorld(), (FactoryPanelConnection)connection);
            if (linkAt == null) {
                return;
            }
            if (!linkAt.isOutput()) continue;
            shouldPower |= linkAt.shouldPanelBePowered();
        }
        for (FactoryPanelConnection connection : this.targetedBy.values()) {
            if (!this.getWorld().isLoaded(connection.from.pos())) {
                return;
            }
            FactoryPanelBehaviour at = CounterPanelBehaviour.at((BlockAndTintGetter)this.getWorld(), (FactoryPanelConnection)connection);
            if (at == null) {
                return;
            }
            Optional<Integer> opt = PanelConnections.getConnectionValue(at, PanelConnections.REDSTONE);
            if (opt.isEmpty()) continue;
            shouldPower |= opt.get() > 0;
        }
        if (shouldPower == this.power) {
            return;
        }
        this.power = shouldPower;
        if (shouldPower) {
            this.count = this.count >= this.value ? 0 : ++this.count;
        }
        this.blockEntity.notifyUpdate();
        this.notifyRedstoneOutputs();
    }

    @Override
    public MutableComponent getDisplayLinkComponent(boolean shortened) {
        return Component.literal((String)(shortened ? String.valueOf(this.count) : this.count + "/" + this.value));
    }
}

