/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.mixin;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.EnumMap;
import java.util.Objects;
import net.liukrast.eg.api.GaugeRegistry;
import net.liukrast.eg.api.logistics.board.AbstractPanelBehaviour;
import net.liukrast.eg.api.registry.PanelType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FactoryPanelBlockEntity.class}, remap=false)
public abstract class FactoryPanelBlockEntityMixin {
    @Shadow
    public EnumMap<FactoryPanelBlock.PanelSlot, FactoryPanelBehaviour> panels;

    @Inject(method={"read"}, at={@At(value="HEAD")})
    private void read(CompoundTag tag, boolean clientPacket, CallbackInfo ci) {
        FactoryPanelBlockEntity instance = (FactoryPanelBlockEntity)FactoryPanelBlockEntity.class.cast(this);
        for (FactoryPanelBlock.PanelSlot slot : FactoryPanelBlock.PanelSlot.values()) {
            CompoundTag customPanels;
            String key = CreateLang.asId((String)slot.name());
            FactoryPanelBehaviour behaviour = null;
            if (tag.m_128441_("CustomPanels") && (customPanels = tag.m_128469_("CustomPanels")).m_128441_(key)) {
                ResourceLocation id = ResourceLocation.parse((String)customPanels.m_128461_(key));
                PanelType type = Objects.requireNonNull((PanelType)GaugeRegistry.PANEL_REGISTRY.get().getValue(id));
                if (type.asClass().equals(this.panels.get(slot).getClass())) continue;
                behaviour = type.create(instance, slot);
            }
            if (behaviour == null) {
                behaviour = new FactoryPanelBehaviour(instance, slot);
            }
            this.panels.put(slot, behaviour);
            instance.attachBehaviourLate((BlockEntityBehaviour)behaviour);
        }
    }

    @Inject(method={"destroy"}, at={@At(value="HEAD")})
    private void destroy(CallbackInfo ci) {
        FactoryPanelBlockEntity instance = (FactoryPanelBlockEntity)FactoryPanelBlockEntity.class.cast(this);
        for (FactoryPanelBehaviour panel : this.panels.values()) {
            ItemStack itemStack;
            if (!panel.active) continue;
            BlockPos blockPos = instance.m_58899_();
            if (panel instanceof AbstractPanelBehaviour) {
                AbstractPanelBehaviour ab = (AbstractPanelBehaviour)panel;
                itemStack = ab.getItem().m_7968_();
            } else {
                itemStack = AllBlocks.FACTORY_GAUGE.asStack();
            }
            Block.m_49840_((Level)Objects.requireNonNull(instance.m_58904_()), (BlockPos)blockPos, (ItemStack)itemStack);
        }
    }
}

