/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.content.logistics.board;

import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelSupportBehaviour;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.ArrayList;
import java.util.Optional;
import net.liukrast.eg.api.logistics.board.AbstractPanelBehaviour;
import net.liukrast.eg.api.logistics.board.PanelConnections;
import net.liukrast.eg.api.registry.PanelType;
import net.liukrast.eg.content.logistics.board.LogicalMode;
import net.liukrast.eg.content.logistics.board.ScrollOptionPanelBehaviour;
import net.liukrast.eg.registry.RegisterItems;
import net.liukrast.eg.registry.RegisterPartialModels;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;

public class LogicPanelBehaviour
extends ScrollOptionPanelBehaviour<LogicalMode> {
    public boolean power;

    public LogicPanelBehaviour(PanelType<?> type, FactoryPanelBlockEntity be, FactoryPanelBlock.PanelSlot slot) {
        super((Component)Component.m_237115_((String)"create.logistics.logic_gate"), type, be, slot, LogicalMode.class);
    }

    @Override
    public void addConnections(AbstractPanelBehaviour.PanelConnectionBuilder builder) {
        builder.put(PanelConnections.REDSTONE, () -> this.power ? 15 : 0);
    }

    @Override
    public void easyWrite(CompoundTag nbt, boolean clientPacket) {
        super.easyWrite(nbt, clientPacket);
        nbt.m_128379_("Power", this.power);
    }

    @Override
    public void easyRead(CompoundTag nbt, boolean clientPacket) {
        super.easyRead(nbt, clientPacket);
        this.power = nbt.m_128471_("Power");
    }

    @Override
    public Item getItem() {
        return (Item)RegisterItems.LOGIC_GAUGE.get();
    }

    @Override
    public PartialModel getModel(FactoryPanelBlock.PanelState panelState, FactoryPanelBlock.PanelType panelType) {
        return RegisterPartialModels.LOGIC_PANEL;
    }

    public void checkForRedstoneInput() {
        if (!this.active) {
            return;
        }
        ArrayList<Boolean> powerList = new ArrayList<Boolean>();
        for (FactoryPanelConnection connection : this.targetedByLinks.values()) {
            if (!this.getWorld().m_46749_(connection.from.pos())) {
                return;
            }
            FactoryPanelSupportBehaviour linkAt = LogicPanelBehaviour.linkAt((BlockAndTintGetter)this.getWorld(), (FactoryPanelConnection)connection);
            if (linkAt == null) {
                return;
            }
            if (!linkAt.isOutput()) continue;
            powerList.add(linkAt.shouldPanelBePowered());
        }
        for (FactoryPanelConnection connection : this.targetedBy.values()) {
            if (!this.getWorld().m_46749_(connection.from.pos())) {
                return;
            }
            FactoryPanelBehaviour at = LogicPanelBehaviour.at((BlockAndTintGetter)this.getWorld(), (FactoryPanelConnection)connection);
            if (at == null) {
                return;
            }
            Optional<Integer> opt = PanelConnections.getConnectionValue(at, PanelConnections.REDSTONE);
            if (opt.isEmpty()) continue;
            powerList.add(opt.get() > 0);
        }
        boolean shouldPower = ((LogicalMode)((Object)this.get())).test(powerList.stream());
        if (shouldPower == this.power) {
            return;
        }
        this.power = shouldPower;
        this.blockEntity.notifyUpdate();
        this.notifyRedstoneOutputs();
    }

    @Override
    public MutableComponent getDisplayLinkComponent(boolean shortened) {
        boolean active = this.getConnectionValue(PanelConnections.REDSTONE).orElse(0) > 0;
        Object t = "\u2714";
        Object f = "\u2716";
        if (!shortened) {
            t = (String)t + " True";
            f = (String)f + " False";
        }
        return Component.m_237113_((String)(active ? t : f));
    }
}

