/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.content.logistics.board;

import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelSupportBehaviour;
import com.simibubi.create.content.redstone.link.RedstoneLinkBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.ArrayList;
import java.util.Optional;
import net.liukrast.eg.api.logistics.board.AbstractPanelBehaviour;
import net.liukrast.eg.api.logistics.board.PanelConnections;
import net.liukrast.eg.api.registry.PanelType;
import net.liukrast.eg.content.logistics.board.IntOperationMode;
import net.liukrast.eg.content.logistics.board.ScrollOptionPanelBehaviour;
import net.liukrast.eg.registry.RegisterItems;
import net.liukrast.eg.registry.RegisterPartialModels;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;

public class IntPanelBehaviour
extends ScrollOptionPanelBehaviour<IntOperationMode> {
    public IntPanelBehaviour(PanelType<?> type, FactoryPanelBlockEntity be, FactoryPanelBlock.PanelSlot slot) {
        super((Component)Component.m_237115_((String)"create.logistics.int_operation"), type, be, slot, IntOperationMode.class);
    }

    @Override
    public void addConnections(AbstractPanelBehaviour.PanelConnectionBuilder builder) {
        builder.put(PanelConnections.INTEGER, () -> this.count);
        builder.put(PanelConnections.REDSTONE, () -> Mth.m_14045_((int)this.count, (int)0, (int)15));
    }

    @Override
    public void easyWrite(CompoundTag nbt, boolean clientPacket) {
        super.easyWrite(nbt, clientPacket);
        nbt.m_128405_("Count", this.count);
    }

    @Override
    public void easyRead(CompoundTag nbt, boolean clientPacket) {
        super.easyRead(nbt, clientPacket);
        this.count = nbt.m_128451_("Count");
    }

    @Override
    public Item getItem() {
        return (Item)RegisterItems.INT_GAUGE.get();
    }

    @Override
    public PartialModel getModel(FactoryPanelBlock.PanelState panelState, FactoryPanelBlock.PanelType panelType) {
        return RegisterPartialModels.INT_PANEL;
    }

    public void checkForRedstoneInput() {
        if (!this.active) {
            return;
        }
        ArrayList<Integer> countList = new ArrayList<Integer>();
        for (FactoryPanelConnection connection : this.targetedByLinks.values()) {
            SmartBlockEntity smartBlockEntity;
            if (!this.getWorld().m_46749_(connection.from.pos())) {
                return;
            }
            FactoryPanelSupportBehaviour linkAt = IntPanelBehaviour.linkAt((BlockAndTintGetter)this.getWorld(), (FactoryPanelConnection)connection);
            if (linkAt == null) {
                return;
            }
            if (!linkAt.isOutput()) continue;
            if (linkAt.shouldPanelBePowered() && (smartBlockEntity = linkAt.blockEntity) instanceof RedstoneLinkBlockEntity) {
                RedstoneLinkBlockEntity redstoneLink = (RedstoneLinkBlockEntity)smartBlockEntity;
                countList.add(redstoneLink.getReceivedSignal());
                continue;
            }
            countList.add(linkAt.shouldPanelBePowered() ? 1 : 0);
        }
        for (FactoryPanelConnection connection : this.targetedBy.values()) {
            if (!this.getWorld().m_46749_(connection.from.pos())) {
                return;
            }
            FactoryPanelBehaviour at = IntPanelBehaviour.at((BlockAndTintGetter)this.getWorld(), (FactoryPanelConnection)connection);
            if (at == null) {
                return;
            }
            Optional<Integer> opt = PanelConnections.getConnectionValue(at, PanelConnections.INTEGER);
            if (opt.isEmpty()) continue;
            countList.add(opt.get());
        }
        int result = ((IntOperationMode)((Object)this.get())).test(countList.stream());
        if (result == this.count) {
            return;
        }
        this.count = result;
        this.blockEntity.notifyUpdate();
        this.notifyRedstoneOutputs();
    }

    @Override
    public MutableComponent getDisplayLinkComponent(boolean shortened) {
        int n = this.getConnectionValue(PanelConnections.INTEGER).orElse(0);
        String text = shortened ? IntPanelBehaviour.formatNumber(n) : String.valueOf(n);
        return Component.m_237113_((String)text);
    }

    private static String formatNumber(int number) {
        boolean negative = number < 0;
        if ((number = Math.abs(number)) >= 1000000) {
            return (negative ? "-" : "") + String.format("%.1fM", Float.valueOf((float)number / 1000000.0f));
        }
        if (number >= 1000) {
            return (negative ? "-" : "") + String.format("%.1fK", Float.valueOf((float)number / 1000.0f));
        }
        return (negative ? "-" : "") + number;
    }
}

