/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.content.logistics.board;

import com.simibubi.create.AllKeys;
import com.simibubi.create.AllPackets;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsPacket;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.utility.CreateLang;
import net.createmod.catnip.gui.element.ScreenElement;
import net.liukrast.eg.ExtraGauges;
import net.liukrast.eg.api.logistics.board.BasicPanelScreen;
import net.liukrast.eg.api.logistics.board.PanelConnections;
import net.liukrast.eg.content.logistics.board.ComparatorMode;
import net.liukrast.eg.content.logistics.board.ComparatorPanelBehaviour;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ComparatorPanelScreen
extends BasicPanelScreen {
    public static final ResourceLocation TEXTURE = ExtraGauges.id("textures/gui/comparator_gauge.png");
    private int current;
    private IconButton[] buttons;

    public ComparatorPanelScreen(ComparatorPanelBehaviour behaviour) {
        super((Component)Component.m_237115_((String)"create.logistics.comparator_gauge.title"), behaviour);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.buttons = new IconButton[ComparatorMode.values().length];
        for (int i = 0; i < ComparatorMode.values().length; ++i) {
            ComparatorMode mode = ComparatorMode.values()[i];
            int fX = x + this.windowWidth / 2 + i * 32 - ComparatorMode.values().length * 16 + 3;
            IconButton button = new IconButton(fX, y + this.windowHeight / 3, (ScreenElement)mode.getIcon());
            int finalI = i;
            button.withCallback(() -> this.activateButton(finalI));
            button.setToolTip((Component)CreateLang.translate((String)mode.getTranslationKey(), (Object[])new Object[0]).component());
            if (((ComparatorPanelBehaviour)this.behaviour).comparatorMode == i) {
                button.setActive(false);
                this.current = i;
            }
            this.m_142416_((GuiEventListener)button);
            this.buttons[i] = button;
        }
    }

    private void activateButton(int i) {
        AllPackets.getChannel().sendToServer((Object)new ValueSettingsPacket(this.behaviour.blockEntity.m_58899_(), 2, i, null, null, Direction.UP, AllKeys.ctrlDown(), this.behaviour.netId()));
        for (IconButton button : this.buttons) {
            button.setActive(true);
        }
        this.buttons[i].setActive(false);
        this.current = i;
    }

    @Override
    public int getWindowHeight() {
        return 88;
    }

    @Override
    public int getWindowWidth() {
        return 198;
    }

    @Override
    public ResourceLocation getTexture() {
        return TEXTURE;
    }

    @Override
    protected void renderWindow(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWindow(graphics, mouseX, mouseY, partialTicks);
        boolean value = this.behaviour.getConnectionValue(PanelConnections.REDSTONE).orElse(0) > 0;
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)("input " + ComparatorMode.values()[this.current].character() + " value")).m_130940_(value ? ChatFormatting.DARK_GREEN : ChatFormatting.RED), this.guiLeft + this.windowWidth / 2 - 3, this.guiTop + this.windowHeight - 21, -1);
    }
}

