/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.content.logistics.board;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelSupportBehaviour;
import com.simibubi.create.content.redstone.link.RedstoneLinkBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.gui.ScreenOpener;
import net.liukrast.eg.api.logistics.board.AbstractPanelBehaviour;
import net.liukrast.eg.api.logistics.board.PanelConnections;
import net.liukrast.eg.api.registry.PanelType;
import net.liukrast.eg.content.logistics.board.ComparatorMode;
import net.liukrast.eg.content.logistics.board.ComparatorPanelScreen;
import net.liukrast.eg.content.logistics.board.NumericalScrollPanelBehaviour;
import net.liukrast.eg.registry.RegisterItems;
import net.liukrast.eg.registry.RegisterPartialModels;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ComparatorPanelBehaviour
extends NumericalScrollPanelBehaviour {
    int comparatorMode = 0;
    public boolean power = false;

    public ComparatorPanelBehaviour(PanelType<?> type, FactoryPanelBlockEntity be, FactoryPanelBlock.PanelSlot slot) {
        super((Component)Component.m_237115_((String)"create.logistics.comparator_value"), type, be, slot);
        this.between(-256, 256);
    }

    public ValueSettingsBoard createBoard(Player player, BlockHitResult hitResult) {
        ImmutableList rows = ImmutableList.of((Object)Component.m_237113_((String)"Positive").m_130940_(ChatFormatting.BOLD), (Object)Component.m_237113_((String)"Negative").m_130940_(ChatFormatting.BOLD));
        ValueSettingsFormatter formatter = new ValueSettingsFormatter(this::formatSettings);
        return new ValueSettingsBoard(this.label, 256, 32, (List)rows, formatter);
    }

    @Override
    public void setValueSettings(Player player, ValueSettingsBehaviour.ValueSettings valueSetting, boolean ctrlHeld) {
        if (valueSetting.row() == 2) {
            this.comparatorMode = Mth.m_14045_((int)valueSetting.value(), (int)0, (int)(ComparatorMode.values().length - 1));
            this.checkForRedstoneInput();
        } else {
            int value = valueSetting.value();
            if (!valueSetting.equals((Object)this.getValueSettings())) {
                this.playFeedbackSound((BlockEntityBehaviour)this);
            }
            this.setValue(valueSetting.row() == 0 ? value : -value);
        }
    }

    @Override
    public void addConnections(AbstractPanelBehaviour.PanelConnectionBuilder builder) {
        builder.put(PanelConnections.REDSTONE, () -> this.power ? 15 : 0);
    }

    @Override
    public void easyWrite(CompoundTag nbt, boolean clientPacket) {
        super.easyWrite(nbt, clientPacket);
        nbt.m_128405_("ComparatorMode", this.comparatorMode);
        nbt.m_128379_("Power", this.power);
    }

    @Override
    public void easyRead(CompoundTag nbt, boolean clientPacket) {
        super.easyRead(nbt, clientPacket);
        this.comparatorMode = nbt.m_128451_("ComparatorMode");
        this.power = nbt.m_128471_("Power");
    }

    @Override
    public Item getItem() {
        return (Item)RegisterItems.COMPARATOR_GAUGE.get();
    }

    @Override
    public PartialModel getModel(FactoryPanelBlock.PanelState panelState, FactoryPanelBlock.PanelType panelType) {
        return RegisterPartialModels.COMPARATOR_PANEL;
    }

    @Override
    public ValueSettingsBehaviour.ValueSettings getValueSettings() {
        return super.getValueSettings();
    }

    public void checkForRedstoneInput() {
        if (!this.active) {
            return;
        }
        int result = 0;
        for (FactoryPanelConnection connection : this.targetedByLinks.values()) {
            SmartBlockEntity smartBlockEntity;
            if (!this.getWorld().m_46749_(connection.from.pos())) {
                return;
            }
            FactoryPanelSupportBehaviour linkAt = ComparatorPanelBehaviour.linkAt((BlockAndTintGetter)this.getWorld(), (FactoryPanelConnection)connection);
            if (linkAt == null) {
                return;
            }
            if (!linkAt.isOutput()) continue;
            if (linkAt.shouldPanelBePowered() && (smartBlockEntity = linkAt.blockEntity) instanceof RedstoneLinkBlockEntity) {
                RedstoneLinkBlockEntity redstoneLink = (RedstoneLinkBlockEntity)smartBlockEntity;
                result += redstoneLink.getReceivedSignal();
                continue;
            }
            result += linkAt.shouldPanelBePowered() ? 1 : 0;
        }
        for (FactoryPanelConnection connection : this.targetedBy.values()) {
            if (!this.getWorld().m_46749_(connection.from.pos())) {
                return;
            }
            FactoryPanelBehaviour at = ComparatorPanelBehaviour.at((BlockAndTintGetter)this.getWorld(), (FactoryPanelConnection)connection);
            if (at == null) {
                return;
            }
            Optional<Integer> opt = PanelConnections.getConnectionValue(at, PanelConnections.INTEGER);
            if (opt.isEmpty()) continue;
            result += opt.get().intValue();
        }
        boolean shouldPower = ((ComparatorMode[])ComparatorMode.class.getEnumConstants())[this.comparatorMode].test(result, this.value);
        if (shouldPower == this.power) {
            return;
        }
        this.power = shouldPower;
        this.blockEntity.notifyUpdate();
        for (FactoryPanelPosition panelPos : this.targeting) {
            if (!this.getWorld().m_46749_(panelPos.pos())) {
                return;
            }
            FactoryPanelBehaviour behaviour = FactoryPanelBehaviour.at((BlockAndTintGetter)this.getWorld(), (FactoryPanelPosition)panelPos);
            if (behaviour == null) continue;
            behaviour.checkForRedstoneInput();
        }
        this.notifyRedstoneOutputs();
    }

    @Override
    public MutableComponent getDisplayLinkComponent(boolean shortened) {
        boolean active = this.getConnectionValue(PanelConnections.REDSTONE).orElse(0) > 0;
        Object t = "\u2714";
        Object f = "\u2716";
        if (!shortened) {
            t = (String)t + " True";
            f = (String)f + " False";
        }
        return Component.m_237113_((String)(active ? t : f));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void displayScreen(Player player) {
        if (player instanceof LocalPlayer) {
            ScreenOpener.open((Screen)new ComparatorPanelScreen(this));
        }
    }
}

