/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.api.logistics.board;

import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.liukrast.eg.api.logistics.board.AbstractPanelBehaviour;
import net.liukrast.eg.api.logistics.board.AddFactoryConnectionEvent;
import net.liukrast.eg.api.logistics.board.PanelConnection;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class PanelConnections {
    public static final PanelConnection<ItemStack> FILTER = new PanelConnection<ItemStack>(){

        @Override
        public int getColor(ItemStack from, ItemStack to) {
            return 0;
        }
    };
    public static final PanelConnection<Integer> REDSTONE = new PanelConnection<Integer>(){

        @Override
        public int getColor(Integer from, Integer to) {
            return to > 0 ? 0xEF0000 : 5767425;
        }
    };
    public static final PanelConnection<Integer> INTEGER = new PanelConnection<Integer>(){

        @Override
        public int getColor(Integer from, Integer to) {
            return 25750;
        }
    };
    static final Map<PanelConnection<?>, Function<FactoryPanelBehaviour, ?>> FACTORY_CONNECTIONS = new Reference2ObjectArrayMap();

    public static <T> Optional<T> getConnectionValue(FactoryPanelBehaviour behaviour, PanelConnection<T> panelConnection) {
        if (behaviour instanceof AbstractPanelBehaviour) {
            AbstractPanelBehaviour abstractPanelBehaviour = (AbstractPanelBehaviour)behaviour;
            return abstractPanelBehaviour.getConnectionValue(panelConnection);
        }
        if (!FACTORY_CONNECTIONS.containsKey(panelConnection)) {
            return Optional.empty();
        }
        return Optional.of(FACTORY_CONNECTIONS.get(panelConnection).apply(behaviour));
    }

    public static Map<PanelConnection<?>, Supplier<?>> getConnections(FactoryPanelBehaviour behaviour) {
        if (behaviour instanceof AbstractPanelBehaviour) {
            AbstractPanelBehaviour ab = (AbstractPanelBehaviour)behaviour;
            return ab.getConnections();
        }
        HashMap map = new HashMap();
        for (PanelConnection<?> key : FACTORY_CONNECTIONS.keySet()) {
            map.put(key, () -> FACTORY_CONNECTIONS.get(key).apply(behaviour));
        }
        return map;
    }

    static {
        FACTORY_CONNECTIONS.put(FILTER, FilteringBehaviour::getFilter);
        FACTORY_CONNECTIONS.put(INTEGER, FactoryPanelBehaviour::getLevelInStorage);
        FACTORY_CONNECTIONS.put(REDSTONE, b -> b.satisfied && b.count != 0 ? 15 : 0);
        MinecraftForge.EVENT_BUS.post((Event)new AddFactoryConnectionEvent());
    }
}

