/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.api.logistics.board;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.liukrast.eg.api.logistics.board.AbstractPanelBehaviour;
import net.liukrast.eg.api.registry.PanelType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import org.jetbrains.annotations.NotNull;

public class PanelBlockItem
extends BlockItem {
    private final Supplier<PanelType<?>> type;

    public PanelBlockItem(Supplier<PanelType<?>> type, Item.Properties properties) {
        super((Block)AllBlocks.FACTORY_GAUGE.get(), properties);
        this.type = type;
    }

    protected AbstractPanelBehaviour getNewBehaviourInstance(FactoryPanelBlockEntity blockEntity, FactoryPanelBlock.PanelSlot slot) {
        return this.type.get().create(blockEntity, slot);
    }

    public void applyExtraPlacementData(BlockPlaceContext context, FactoryPanelBlockEntity blockEntity, FactoryPanelBlock.PanelSlot targetedSlot) {
        this.applyToSlot(blockEntity, targetedSlot);
        Component message = this.getPlacedMessage();
        Player player = context.m_43723_();
        if (player == null) {
            return;
        }
        ItemStack stack = context.m_43722_();
        if (!context.m_43723_().m_7500_()) {
            stack.m_41774_(1);
            if (stack.m_41619_()) {
                player.m_21008_(context.m_43724_(), ItemStack.f_41583_);
            }
        }
        if (message != null) {
            player.m_5661_(message, true);
        }
    }

    public boolean applyToSlot(FactoryPanelBlockEntity blockEntity, FactoryPanelBlock.PanelSlot slot) {
        FactoryPanelBehaviour oldBehaviour = (FactoryPanelBehaviour)blockEntity.panels.get(slot);
        if (oldBehaviour == null || !oldBehaviour.isActive()) {
            AbstractPanelBehaviour newBehaviour = this.getNewBehaviourInstance(blockEntity, slot);
            newBehaviour.active = true;
            blockEntity.attachBehaviourLate((BlockEntityBehaviour)newBehaviour);
            blockEntity.panels.put(slot, newBehaviour);
            blockEntity.redraw = true;
            blockEntity.lastShape = null;
            blockEntity.notifyUpdate();
            if (blockEntity.activePanels() > 1) {
                SoundType soundType = blockEntity.m_58900_().m_60827_();
                blockEntity.m_58904_().m_5594_(null, blockEntity.m_58899_(), soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
            }
            return true;
        }
        return false;
    }

    public Component isReadyForPlacement(ItemStack stack, Level level, BlockPos pos, Player player) {
        return null;
    }

    @Nullable
    public Component getPlacedMessage() {
        return null;
    }

    public void m_6192_(@NotNull Map<Block, Item> blockToItemMap, @NotNull Item item) {
    }

    @NotNull
    public String m_5524_() {
        return this.m_41467_();
    }
}

