/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.deployer.lib.registry;

import com.simibubi.create.AllDisplaySources;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.redstone.displayLink.source.FactoryGaugeDisplaySource;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import net.createmod.catnip.data.IntAttached;
import net.liukrast.deployer.lib.logistics.board.AbstractPanelBehaviour;
import net.liukrast.deployer.lib.logistics.board.connection.PanelConnection;
import net.liukrast.deployer.lib.registry.DeployerRegistries;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.ApiStatus;

public class DeployerPanelConnections {
    private static final DeferredRegister<PanelConnection<?>> CONNECTIONS = DeferredRegister.create(DeployerRegistries.PANEL_CONNECTION, (String)"deployer");
    public static final DeferredHolder<PanelConnection<?>, PanelConnection<ItemStack>> ITEM_STACK = CONNECTIONS.register("filter", () -> new PanelConnection<ItemStack>(FilteringBehaviour::getFilter));
    public static final DeferredHolder<PanelConnection<?>, PanelConnection<FluidStack>> FLUID_STACK = CONNECTIONS.register("fluid_filter", () -> new PanelConnection<FluidStack>(b -> {
        IFluidHandlerItem handler = (IFluidHandlerItem)b.getFilter().getCapability(Capabilities.FluidHandler.ITEM);
        if (handler == null || handler.getTanks() == 0) {
            return FluidStack.EMPTY;
        }
        return handler.getFluidInTank(0);
    }));
    public static final DeferredHolder<PanelConnection<?>, PanelConnection<Integer>> REDSTONE = CONNECTIONS.register("redstone", () -> new PanelConnection<Integer>(b -> b.satisfied && b.count != 0 ? 15 : 0));
    public static final DeferredHolder<PanelConnection<?>, PanelConnection<Integer>> INTEGER = CONNECTIONS.register("integer", () -> new PanelConnection<Integer>(FactoryPanelBehaviour::getLevelInStorage));
    public static final DeferredHolder<PanelConnection<?>, PanelConnection<String>> STRING = CONNECTIONS.register("string", () -> new PanelConnection<String>(b -> {
        IntAttached source = ((FactoryGaugeDisplaySource)AllDisplaySources.GAUGE_STATUS.get()).createEntry(b.getWorld(), b.getPanelPosition());
        return source == null ? null : String.valueOf(source.getFirst()) + ((MutableComponent)source.getValue()).getString();
    }));

    private DeployerPanelConnections() {
    }

    public static <T> Optional<T> getConnectionValue(FactoryPanelBehaviour behaviour, DeferredHolder<PanelConnection<?>, PanelConnection<T>> panelConnection) {
        return DeployerPanelConnections.getConnectionValue(behaviour, (PanelConnection)panelConnection.get());
    }

    public static <T> Optional<T> getConnectionValue(FactoryPanelBehaviour behaviour, PanelConnection<T> panelConnection) {
        if (behaviour == null) {
            return Optional.empty();
        }
        if (behaviour instanceof AbstractPanelBehaviour) {
            AbstractPanelBehaviour abstractPanelBehaviour = (AbstractPanelBehaviour)behaviour;
            return abstractPanelBehaviour.getConnectionValue(panelConnection);
        }
        return Optional.ofNullable(panelConnection.getDefault(behaviour));
    }

    public static Set<PanelConnection<?>> getConnections(FactoryPanelBehaviour behaviour) {
        if (behaviour == null) {
            return Set.of();
        }
        if (behaviour instanceof AbstractPanelBehaviour) {
            AbstractPanelBehaviour ab = (AbstractPanelBehaviour)behaviour;
            return ab.getConnections();
        }
        return new LinkedHashSet(CONNECTIONS.getEntries().stream().map(DeferredHolder::get).toList());
    }

    @ApiStatus.Internal
    public static void register(IEventBus eventBus) {
        CONNECTIONS.register(eventBus);
    }
}

