/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.deployer.lib.registry;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import java.util.HashMap;
import java.util.Map;
import net.liukrast.deployer.lib.logistics.OrderStockTypeData;
import net.liukrast.deployer.lib.logistics.packager.StockInventoryType;
import net.liukrast.deployer.lib.logistics.stockTicker.GenericOrderContained;
import net.liukrast.deployer.lib.registry.DeployerRegistries;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public class DeployerDataComponents {
    private static final DeferredRegister<DataComponentType<?>> DATA_COMPONENTS = DeferredRegister.create((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"deployer");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<OrderStockTypeData>> ORDER_STOCK_TYPE_DATA = DATA_COMPONENTS.register("order_stock_type_data", () -> DataComponentType.builder().persistent(OrderStockTypeData.CODEC).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Map<StockInventoryType<?, ?, ?>, GenericOrderContained<?>>>> EXTRA_REQUEST_DATA = DATA_COMPONENTS.register("extra_request_data", () -> DataComponentType.builder().persistent(new Codec<Map<StockInventoryType<?, ?, ?>, GenericOrderContained<?>>>(){

        public <T> DataResult<Pair<Map<StockInventoryType<?, ?, ?>, GenericOrderContained<?>>, T>> decode(DynamicOps<T> ops, T input) {
            HashMap map = new HashMap();
            ((MapLike)ops.getMap(input).getOrThrow()).entries().forEach(pair -> {
                ResourceLocation id = (ResourceLocation)((Pair)ResourceLocation.CODEC.decode(ops, pair.getFirst()).getOrThrow()).getFirst();
                StockInventoryType type = (StockInventoryType)DeployerRegistries.STOCK_INVENTORY.get(id);
                if (type == null) {
                    return;
                }
                GenericOrderContained e = (GenericOrderContained)((Pair)type.valueHandler().orderContainedCodec().decode(ops, pair.getSecond()).getOrThrow()).getFirst();
                map.put(type, e);
            });
            return DataResult.success((Object)Pair.of(map, (Object)ops.empty()));
        }

        public <T> DataResult<T> encode(Map<StockInventoryType<?, ?, ?>, GenericOrderContained<?>> input, DynamicOps<T> ops, T prefix) {
            HashMap map = new HashMap();
            input.forEach((key, value) -> {
                ResourceLocation id = DeployerRegistries.STOCK_INVENTORY.getKey(key);
                if (id == null) {
                    return;
                }
                Object k = ResourceLocation.CODEC.encode((Object)id, ops, prefix).getOrThrow();
                Object v = this.encodeS((StockInventoryType)key, (GenericOrderContained)value, ops, prefix);
                map.put(k, v);
            });
            return DataResult.success((Object)ops.createMap(map));
        }

        private <V, T> T encodeS(StockInventoryType<?, V, ?> type, GenericOrderContained<V> order, DynamicOps<T> ops, T prefix) {
            return (T)type.valueHandler().orderContainedCodec().encode(order, ops, prefix).getOrThrow();
        }
    }).networkSynchronized(new StreamCodec<RegistryFriendlyByteBuf, Map<StockInventoryType<?, ?, ?>, GenericOrderContained<?>>>(){

        @NotNull
        public Map<StockInventoryType<?, ?, ?>, GenericOrderContained<?>> decode(@NotNull RegistryFriendlyByteBuf buf) {
            int size = buf.readVarInt();
            HashMap map = new HashMap();
            for (int i = 0; i < size; ++i) {
                ResourceLocation id = buf.readResourceLocation();
                StockInventoryType type = (StockInventoryType)DeployerRegistries.STOCK_INVENTORY.get(id);
                if (type == null) {
                    throw new IllegalStateException("Stock inventory not registered");
                }
                GenericOrderContained val = (GenericOrderContained)type.valueHandler().orderContainedStreamCodec().decode((Object)buf);
                map.put(type, val);
            }
            return map;
        }

        public void encode(@NotNull RegistryFriendlyByteBuf buf, @NotNull Map<StockInventoryType<?, ?, ?>, GenericOrderContained<?>> val) {
            buf.writeVarInt(val.size());
            val.forEach((key, val1) -> {
                ResourceLocation id = DeployerRegistries.STOCK_INVENTORY.getKey(key);
                if (id == null) {
                    throw new IllegalStateException("Stock inventory not registered");
                }
                buf.writeResourceLocation(id);
                this.encodeS((StockInventoryType)key, (GenericOrderContained)val1, buf);
            });
        }

        private <V> void encodeS(StockInventoryType<?, V, ?> type, GenericOrderContained<V> entry, RegistryFriendlyByteBuf buf) {
            type.valueHandler().orderContainedStreamCodec().encode((Object)buf, entry);
        }
    }).build());

    private DeployerDataComponents() {
    }

    public static void register(IEventBus eventBus) {
        DATA_COMPONENTS.register(eventBus);
    }
}

