/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.deployer.lib.mixin;

import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.platform.CatnipServices;
import net.liukrast.deployer.lib.logistics.packager.AbstractInventorySummary;
import net.liukrast.deployer.lib.logistics.packager.IdentifiedContainer;
import net.liukrast.deployer.lib.logistics.packager.StockInventoryType;
import net.liukrast.deployer.lib.logistics.stockTicker.Deployer$MappedInfo;
import net.liukrast.deployer.lib.logistics.stockTicker.GenericOrderContained;
import net.liukrast.deployer.lib.logistics.stockTicker.LogisticalStockGenericRequestPacket;
import net.liukrast.deployer.lib.mixin.StockCheckingBlockEntityMixin;
import net.liukrast.deployer.lib.mixinExtensions.STBEExtension;
import net.liukrast.deployer.lib.registry.DeployerRegistries;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StockTickerBlockEntity.class})
public abstract class StockTickerBlockEntityMixin
extends StockCheckingBlockEntityMixin
implements STBEExtension {
    @Shadow
    protected String previouslyUsedAddress;
    @Shadow
    protected List<ItemStack> categories;
    @Unique
    private final Deployer$MappedInfo deployer$mappedInfo = new Deployer$MappedInfo();

    public StockTickerBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Inject(method={"refreshClientStockSnapshot"}, at={@At(value="TAIL")})
    private void refreshClientStockSnapshot(CallbackInfo ci) {
        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new LogisticalStockGenericRequestPacket(this.worldPosition));
    }

    @Override
    public <K, V, H> List<List<V>> deployer$getClientStockSnapshot(StockInventoryType<K, V, H> type) {
        return this.deployer$mappedInfo.getLastClientsideStockSnapshot(type);
    }

    @Override
    public <K, V, H> AbstractInventorySummary<K, V> deployer$getLastClientsideStockSnapshotAsSummary(StockInventoryType<K, V, H> type) {
        return this.deployer$mappedInfo.getLastClientsideStockSnapshotAsSummary(type);
    }

    @Override
    public boolean deployer$broadcastAllPackageRequest(PackageOrderWithCrafts defaultOrder, LogisticallyLinkedBehaviour.RequestType requestType, Map<StockInventoryType<?, ?, ?>, GenericOrderContained<?>> requests, String address) {
        boolean result = super.deployer$broadcastAllPackageRequest(defaultOrder, requestType, requests, address);
        this.previouslyUsedAddress = address;
        this.notifyUpdate();
        return result;
    }

    @Override
    public <K, V, H> boolean deployer$broadcastPackageRequest(StockInventoryType<K, V, H> type, LogisticallyLinkedBehaviour.RequestType requestType, GenericOrderContained<V> order, IdentifiedContainer<H> ignoredHandler, String address) {
        boolean result = super.deployer$broadcastPackageRequest(type, requestType, order, ignoredHandler, address);
        this.previouslyUsedAddress = address;
        this.notifyUpdate();
        return result;
    }

    @Override
    public <K, V, H> AbstractInventorySummary<K, V> deployer$getRecentSummary(StockInventoryType<K, V, H> type) {
        AbstractInventorySummary<K, V> recentSummary = super.deployer$getRecentSummary(type);
        int contributingLinks = recentSummary.contributingLinks;
        if (this.deployer$mappedInfo.getActiveLinks(type) != contributingLinks && !this.isRemoved()) {
            this.deployer$mappedInfo.setActiveLinks(type, contributingLinks);
            this.sendData();
        }
        return recentSummary;
    }

    @Inject(method={"write"}, at={@At(value="TAIL")})
    private void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket, CallbackInfo ci) {
        if (!clientPacket) {
            return;
        }
        CompoundTag activeLinks = new CompoundTag();
        for (StockInventoryType type : DeployerRegistries.STOCK_INVENTORY) {
            String id = DeployerRegistries.STOCK_INVENTORY.getKey((Object)type).toString();
            activeLinks.putInt(id, this.deployer$mappedInfo.getActiveLinks(type));
        }
        tag.put("deployer$ActiveLinks", (Tag)activeLinks);
    }

    @Inject(method={"read"}, at={@At(value="TAIL")})
    private void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket, CallbackInfo ci) {
        if (!clientPacket) {
            return;
        }
        CompoundTag activeLinks = tag.getCompound("deployer$ActiveLinks");
        for (StockInventoryType type : DeployerRegistries.STOCK_INVENTORY) {
            String id = DeployerRegistries.STOCK_INVENTORY.getKey((Object)type).toString();
            this.deployer$mappedInfo.setActiveLinks(type, activeLinks.getInt(id));
        }
    }

    public <K, V, H> void deployer$receiveStockPacket(StockInventoryType<K, V, H> type, List<V> stacks, boolean endOfTransmission) {
        this.deployer$mappedInfo.setNewlyReceivedStockSnapshot(type, new ArrayList());
        this.deployer$mappedInfo.getNewlyReceivedStockSnapshot(type).addAll(stacks);
        if (!endOfTransmission) {
            return;
        }
        this.deployer$mappedInfo.setLastClientsideStockSnapshotAsSummary(type, type.networkHandler().createSummary());
        this.deployer$mappedInfo.setLastClientsideStockSnapshot(type, new ArrayList());
        for (V stack : this.deployer$mappedInfo.getNewlyReceivedStockSnapshot(type)) {
            this.deployer$mappedInfo.getLastClientsideStockSnapshotAsSummary(type).add(stack);
        }
        for (ItemStack filter : this.categories) {
            ArrayList<V> inCategory = new ArrayList<V>();
            if (!filter.isEmpty()) {
                FilterItemStack filterItemStack = FilterItemStack.of((ItemStack)filter);
                Iterator<V> iterator = this.deployer$mappedInfo.getNewlyReceivedStockSnapshot(type).iterator();
                while (iterator.hasNext()) {
                    V stack = iterator.next();
                    if (!type.valueHandler().test(filterItemStack, this.level, stack)) continue;
                    inCategory.add(stack);
                    iterator.remove();
                }
            }
            this.deployer$mappedInfo.getLastClientsideStockSnapshot(type).add(inCategory);
        }
        ArrayList<V> unsorted = new ArrayList<V>(this.deployer$mappedInfo.getNewlyReceivedStockSnapshot(type));
        this.deployer$mappedInfo.getLastClientsideStockSnapshot(type).add(unsorted);
        this.deployer$mappedInfo.setNewlyReceivedStockSnapshot(type, null);
    }

    @Override
    public Deployer$MappedInfo deployer$getMappedInfo() {
        return this.deployer$mappedInfo;
    }
}

