/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.deployer.lib.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import com.simibubi.create.content.logistics.packager.PackagerItemHandler;
import net.liukrast.deployer.lib.logistics.packager.AbstractPackagerBlockEntity;
import net.liukrast.deployer.lib.logistics.packager.GenericPackageItem;
import net.liukrast.deployer.lib.logistics.packager.PackageCanBeHandled;
import net.liukrast.deployer.lib.logistics.packager.StockInventoryType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={PackagerItemHandler.class})
public class PackagerItemHandlerMixin {
    @Shadow
    private PackagerBlockEntity blockEntity;

    @WrapOperation(method={"insertItem"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/packager/PackagerBlockEntity;unwrapBox(Lnet/minecraft/world/item/ItemStack;Z)Z", ordinal=0)})
    private boolean insertItem(PackagerBlockEntity instance, ItemStack box, boolean simulate, Operation<Boolean> original) {
        PackagerBlockEntity packagerBlockEntity = this.blockEntity;
        if (packagerBlockEntity instanceof AbstractPackagerBlockEntity) {
            AbstractPackagerBlockEntity aPBE = (AbstractPackagerBlockEntity)packagerBlockEntity;
            Item item = box.getItem();
            if (!(item instanceof GenericPackageItem)) {
                return true;
            }
            GenericPackageItem generic = (GenericPackageItem)item;
            StockInventoryType type = aPBE.getStockType();
            if (generic.getType() != type) {
                return true;
            }
        } else if (box.getItem() instanceof GenericPackageItem) {
            return true;
        }
        return (Boolean)original.call(new Object[]{instance, box, simulate});
    }

    @ModifyReturnValue(method={"isItemValid"}, at={@At(value="RETURN")})
    private boolean isItemValid(boolean original, @Local(argsOnly=true, name={"arg2"}) ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof PackageCanBeHandled) {
            PackageCanBeHandled pCBH = (PackageCanBeHandled)item;
            return pCBH.canBeHandled(stack);
        }
        return original;
    }
}

