/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.deployer.lib.mixin;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Definitions;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Cancellable;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.serialization.Codec;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBlockItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.createmod.catnip.codecs.CatnipCodecUtils;
import net.liukrast.deployer.lib.logistics.LogisticallyLinked;
import net.liukrast.deployer.lib.logistics.board.AbstractPanelBehaviour;
import net.liukrast.deployer.lib.logistics.board.connection.ConnectionExtra;
import net.liukrast.deployer.lib.logistics.board.connection.PanelConnection;
import net.liukrast.deployer.lib.mixinExtensions.FPBExtension;
import net.liukrast.deployer.lib.registry.DeployerPanelConnections;
import net.liukrast.deployer.lib.registry.DeployerRegistries;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FactoryPanelBehaviour.class})
public abstract class FactoryPanelBehaviourMixin
implements FPBExtension {
    @Unique
    private final Map<BlockPos, FactoryPanelConnection> deployer$targetedByExtra = new HashMap<BlockPos, FactoryPanelConnection>();
    @Shadow
    public Map<FactoryPanelPosition, FactoryPanelConnection> targetedBy;
    @Shadow
    public UUID network;

    @Shadow
    @Nullable
    public static FactoryPanelBehaviour at(BlockAndTintGetter world, FactoryPanelConnection connection) {
        throw new AssertionError((Object)"Mixin injection failed");
    }

    @Override
    public Map<BlockPos, FactoryPanelConnection> deployer$getExtra() {
        return this.deployer$targetedByExtra;
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/foundation/blockEntity/behaviour/filtering/FilteringBehaviour;tick()V", shift=At.Shift.AFTER)}, cancellable=true)
    private void tick(CallbackInfo ci) {
        AbstractPanelBehaviour ab;
        Object t = FactoryPanelBehaviour.class.cast(this);
        if (t instanceof AbstractPanelBehaviour && (ab = (AbstractPanelBehaviour)((Object)t)).skipOriginalTick()) {
            ci.cancel();
        }
    }

    @WrapOperation(method={"at(Lnet/minecraft/world/level/BlockAndTintGetter;Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelPosition;)Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelBehaviour;"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definitions(value={@Definition(id="behaviour", local={@Local(type=FactoryPanelBehaviour.class)}), @Definition(id="active", field={"Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelBehaviour;active:Z"})})
    @Expression(value={"behaviour.active"})
    private static boolean at(FactoryPanelBehaviour instance, Operation<Boolean> original) {
        if (instance == null) {
            return true;
        }
        return (Boolean)original.call(new Object[]{instance});
    }

    @ModifyVariable(method={"moveTo"}, at=@At(value="STORE", ordinal=0))
    private FactoryPanelBehaviour moveTo(FactoryPanelBehaviour original) {
        FactoryPanelBlockEntity be = (FactoryPanelBlockEntity)original.blockEntity;
        FactoryPanelBlock.PanelSlot slot = original.slot;
        Object v = be.panels.get(slot);
        if (v instanceof AbstractPanelBehaviour) {
            AbstractPanelBehaviour superOriginal = (AbstractPanelBehaviour)((Object)v);
            return superOriginal.getPanelType().create(be, slot);
        }
        return original;
    }

    @Inject(method={"moveTo"}, at={@At(value="INVOKE", target="Ljava/util/Map;keySet()Ljava/util/Set;", ordinal=0)}, cancellable=true)
    private void moveTo(FactoryPanelPosition newPos, ServerPlayer player, CallbackInfo ci) {
        for (BlockPos pos : this.deployer$targetedByExtra.keySet()) {
            if (pos.closerThan((Vec3i)newPos.pos(), 24.0)) continue;
            ci.cancel();
            return;
        }
    }

    @Redirect(method={"tickRequests"}, at=@At(value="FIELD", target="Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelBehaviour;targetedBy:Ljava/util/Map;", opcode=180))
    private Map<FactoryPanelPosition, FactoryPanelConnection> tickRequests(FactoryPanelBehaviour instance) {
        HashMap<FactoryPanelPosition, FactoryPanelConnection> filtered = new HashMap<FactoryPanelPosition, FactoryPanelConnection>();
        block0: for (Map.Entry entry : instance.targetedBy.entrySet()) {
            FactoryPanelBehaviour source = FactoryPanelBehaviour.at((BlockAndTintGetter)instance.getWorld(), (FactoryPanelConnection)((FactoryPanelConnection)entry.getValue()));
            if (source instanceof AbstractPanelBehaviour) {
                AbstractPanelBehaviour ab = (AbstractPanelBehaviour)source;
                for (PanelConnection<?> c : ab.getConnections()) {
                    if (c == DeployerPanelConnections.ITEM_STACK.get()) break;
                    if (c != DeployerPanelConnections.REDSTONE.get() && c != DeployerPanelConnections.INTEGER.get() && c != DeployerPanelConnections.STRING.get()) continue;
                    continue block0;
                }
            }
            filtered.put((FactoryPanelPosition)entry.getKey(), (FactoryPanelConnection)entry.getValue());
        }
        return filtered;
    }

    @Inject(method={"write"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundTag;putUUID(Ljava/lang/String;Ljava/util/UUID;)V")})
    private void write(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket, CallbackInfo ci, @Local(name={"panelTag"}) CompoundTag panelTag) {
        panelTag.put("TargetedByExtra", (Tag)CatnipCodecUtils.encode((Codec)Codec.list((Codec)FactoryPanelConnection.CODEC), new ArrayList<FactoryPanelConnection>(this.deployer$targetedByExtra.values())).orElseThrow());
    }

    @Inject(method={"read"}, at={@At(value="INVOKE", target="Ljava/util/Map;clear()V")})
    private void read(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket, CallbackInfo ci, @Local(name={"panelTag"}) CompoundTag panelTag) {
        this.deployer$targetedByExtra.clear();
        CatnipCodecUtils.decode((Codec)Codec.list((Codec)FactoryPanelConnection.CODEC), (Tag)panelTag.get("TargetedByExtra")).orElse(List.of()).forEach(c -> this.deployer$targetedByExtra.put(c.from.pos(), (FactoryPanelConnection)c));
    }

    @Inject(method={"addConnection"}, at={@At(value="HEAD")}, cancellable=true)
    private void addConnection(FactoryPanelPosition fromPos, CallbackInfo ci) {
        FactoryPanelBehaviour i = (FactoryPanelBehaviour)FactoryPanelBehaviour.class.cast(this);
        BlockState fromState = i.getWorld().getBlockState(fromPos.pos());
        if (PanelConnection.makeContext(i.getWorld().getBlockState(i.getPos())) == PanelConnection.makeContext(fromState) && DeployerRegistries.PANEL_CONNECTION.stream().map(c -> c.getListener(fromState.getBlock())).anyMatch(Objects::nonNull)) {
            this.deployer$targetedByExtra.put(fromPos.pos(), new FactoryPanelConnection(fromPos, 1));
            i.blockEntity.notifyUpdate();
            ci.cancel();
        }
    }

    @Inject(method={"disconnectAllLinks"}, at={@At(value="TAIL")})
    private void disconnectAllLinks(CallbackInfo ci) {
        this.deployer$targetedByExtra.clear();
    }

    @ModifyVariable(method={"checkForRedstoneInput"}, at=@At(value="STORE", ordinal=0), name={"shouldPower"})
    private boolean checkForRedstoneInput(boolean shouldPower, @Cancellable CallbackInfo ci) {
        FactoryPanelBehaviour i = (FactoryPanelBehaviour)FactoryPanelBehaviour.class.cast(this);
        block0: for (FactoryPanelConnection connection : this.targetedBy.values()) {
            if (!i.getWorld().isLoaded(connection.from.pos())) {
                ci.cancel();
                return false;
            }
            Level world = i.getWorld();
            FactoryPanelBehaviour behaviour = FactoryPanelBehaviourMixin.at((BlockAndTintGetter)world, connection);
            if (behaviour == null || !behaviour.isActive()) {
                return false;
            }
            if (!(behaviour instanceof AbstractPanelBehaviour)) continue;
            AbstractPanelBehaviour panel = (AbstractPanelBehaviour)behaviour;
            for (PanelConnection<?> c : panel.getConnections()) {
                if (c == DeployerPanelConnections.ITEM_STACK.get() || c == DeployerPanelConnections.INTEGER.get()) break;
                if (c != DeployerPanelConnections.REDSTONE.get()) continue;
                shouldPower |= panel.getConnectionValue(DeployerPanelConnections.REDSTONE).orElse(0) > 0;
                continue block0;
            }
        }
        for (FactoryPanelConnection connection : this.deployer$targetedByExtra.values()) {
            Optional opt;
            BlockPos pos = connection.from.pos();
            if (!i.getWorld().isLoaded(pos)) {
                ci.cancel();
                return false;
            }
            BlockState state = i.getWorld().getBlockState(pos);
            BlockEntity be = i.getWorld().getBlockEntity(pos);
            ConnectionExtra listener = ((PanelConnection)DeployerPanelConnections.REDSTONE.get()).getListener(state.getBlock());
            if (listener == null || !(opt = listener.invalidate(i.getWorld(), state, pos, be)).isPresent()) continue;
            shouldPower |= (Integer)opt.get() > 0;
        }
        return shouldPower;
    }

    @ModifyExpressionValue(method={"checkForRedstoneInput"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definitions(value={@Definition(id="shouldPower", local={@Local(type=boolean.class)}), @Definition(id="redstonePowered", field={"Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelBehaviour;redstonePowered:Z"})})
    @Expression(value={"shouldPower == this.redstonePowered"})
    private boolean checkForRedstoneInput$1(boolean original) {
        String fAddress;
        FactoryPanelBehaviour i = (FactoryPanelBehaviour)FactoryPanelBehaviour.class.cast(this);
        Integer total = null;
        StringBuilder addressChange = null;
        block0: for (FactoryPanelConnection connection : this.targetedBy.values()) {
            if (!i.getWorld().isLoaded(connection.from.pos())) {
                return false;
            }
            Level world = i.getWorld();
            FactoryPanelBehaviour behaviour = FactoryPanelBehaviourMixin.at((BlockAndTintGetter)world, connection);
            if (behaviour == null || !behaviour.isActive()) {
                return false;
            }
            if (!(behaviour instanceof AbstractPanelBehaviour)) continue;
            AbstractPanelBehaviour panel = (AbstractPanelBehaviour)behaviour;
            Set<PanelConnection<?>> connections = panel.getConnections();
            for (PanelConnection<?> c : connections) {
                if (c == DeployerPanelConnections.ITEM_STACK.get()) break;
                if (c == DeployerPanelConnections.INTEGER.get()) {
                    if (total == null) {
                        total = 0;
                    }
                    total = total + panel.getConnectionValue((PanelConnection)DeployerPanelConnections.INTEGER.get()).orElse(0);
                    continue block0;
                }
                if (c == DeployerPanelConnections.REDSTONE.get()) continue block0;
                if (c != DeployerPanelConnections.STRING.get()) continue;
                if (addressChange == null) {
                    addressChange = new StringBuilder(panel.getConnectionValue((PanelConnection)DeployerPanelConnections.STRING.get()).orElse(""));
                    continue block0;
                }
                addressChange.append(panel.getConnectionValue((PanelConnection)DeployerPanelConnections.STRING.get()).orElse(""));
                continue block0;
            }
        }
        for (FactoryPanelConnection connection : this.deployer$targetedByExtra.values()) {
            Optional opt;
            Optional opt2;
            BlockPos pos = connection.from.pos();
            if (!i.getWorld().isLoaded(pos)) {
                return false;
            }
            BlockState state = i.getWorld().getBlockState(pos);
            BlockEntity be = i.getWorld().getBlockEntity(pos);
            ConnectionExtra redstoneListener = ((PanelConnection)DeployerPanelConnections.REDSTONE.get()).getListener(state.getBlock());
            if (redstoneListener != null && redstoneListener.invalidate(i.getWorld(), state, pos, be).isPresent()) continue;
            ConnectionExtra intListener = ((PanelConnection)DeployerPanelConnections.INTEGER.get()).getListener(state.getBlock());
            if (intListener != null && (opt2 = intListener.invalidate(i.getWorld(), state, pos, be)).isPresent()) {
                total = total + (Integer)opt2.get();
                continue;
            }
            ConnectionExtra listener = ((PanelConnection)DeployerPanelConnections.STRING.get()).getListener(state.getBlock());
            if (listener == null || !(opt = listener.invalidate(i.getWorld(), state, pos, be)).isPresent()) continue;
            if (addressChange == null) {
                addressChange = new StringBuilder((String)opt.get());
                continue;
            }
            addressChange.append((String)opt.get());
        }
        String string = fAddress = addressChange == null ? null : addressChange.toString();
        if (!(total != null && total != i.count || fAddress != null && !fAddress.equals(i.recipeAddress))) {
            return false;
        }
        if (total != null) {
            i.count = total;
        }
        if (fAddress != null) {
            i.recipeAddress = fAddress;
        }
        return true;
    }

    @Inject(method={"notifyRedstoneOutputs"}, at={@At(value="TAIL")})
    private void notifyRedstoneOutputs(CallbackInfo ci) {
    }

    @ModifyExpressionValue(method={"onShortInteract"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEmpty()Z", ordinal=0)})
    private boolean onShortInteract(boolean original) {
        AbstractPanelBehaviour panel;
        FactoryPanelBehaviour instance = (FactoryPanelBehaviour)FactoryPanelBehaviour.class.cast(this);
        return instance instanceof AbstractPanelBehaviour ? (panel = (AbstractPanelBehaviour)instance).withFilteringBehaviour() && original : original;
    }

    @ModifyExpressionValue(method={"onShortInteract"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definitions(value={@Definition(id="heldItem", local={@Local(type=ItemStack.class)}), @Definition(id="getItem", method={"Lnet/minecraft/world/item/ItemStack;getItem()Lnet/minecraft/world/item/Item;"}), @Definition(id="LogisticallyLinkedBlockItem", type={LogisticallyLinkedBlockItem.class})})
    @Expression(value={"heldItem.getItem() instanceof LogisticallyLinkedBlockItem"})
    private boolean onShortInteract$1(boolean original) {
        FactoryPanelBehaviour instance = (FactoryPanelBehaviour)FactoryPanelBehaviour.class.cast(this);
        return original && !(instance instanceof AbstractPanelBehaviour);
    }

    @ModifyExpressionValue(method={"onShortInteract"}, at={@At(value="INVOKE", target="Ljava/util/Map;size()I")})
    private int onShortInteract(int original) {
        return original + this.deployer$targetedByExtra.size();
    }

    @ModifyExpressionValue(method={"onShortInteract"}, at={@At(value="INVOKE", target="Ljava/util/Map;values()Ljava/util/Collection;")})
    private Collection<FactoryPanelConnection> onShortInteract(Collection<FactoryPanelConnection> original) {
        return Stream.concat(original.stream(), this.deployer$targetedByExtra.values().stream()).collect(Collectors.toSet());
    }

    @ModifyExpressionValue(method={"onShortInteract"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definitions(value={@Definition(id="heldItem", local={@Local(type=ItemStack.class, name={"heldItem"})}), @Definition(id="getItem", method={"Lnet/minecraft/world/item/ItemStack;getItem()Lnet/minecraft/world/item/Item;"}), @Definition(id="LogisticallyLinkedBlockItem", type={LogisticallyLinkedBlockItem.class})})
    @Expression(value={"heldItem.getItem() instanceof LogisticallyLinkedBlockItem"})
    private boolean onShortInteract(boolean original, @Local(name={"heldItem"}) ItemStack heldItem) {
        return original || heldItem.getItem() instanceof LogisticallyLinked;
    }
}

