/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.deployer.lib.logistics.stockTicker;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public record GenericOrder<V>(List<V> stacks) {
    public static <V> GenericOrder<V> empty() {
        return new GenericOrder(Collections.emptyList());
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    public static <V> Codec<GenericOrder<V>> simpleCodec(Codec<V> codec) {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)codec).fieldOf("entries").forGetter(GenericOrder::stacks)).apply((Applicative)instance, GenericOrder::new));
    }

    public static <V> StreamCodec<RegistryFriendlyByteBuf, GenericOrder<V>> simpleStreamCodec(StreamCodec<? super RegistryFriendlyByteBuf, V> codec) {
        return StreamCodec.of((buf, val) -> {
            buf.writeVarInt(val.stacks.size());
            for (Object v : val.stacks) {
                codec.encode(buf, v);
            }
        }, buf -> {
            int i = buf.readVarInt();
            ArrayList<Object> list = new ArrayList<Object>();
            for (int j = 0; j < i; ++j) {
                list.add(codec.decode(buf));
            }
            return new GenericOrder(list);
        });
    }
}

