/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.deployer.lib.logistics.packager;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.Codec;
import com.simibubi.create.api.registry.SimpleRegistry;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.content.logistics.stockTicker.StockKeeperRequestScreen;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.createmod.catnip.data.Couple;
import net.liukrast.deployer.lib.logistics.GenericPackageOrderData;
import net.liukrast.deployer.lib.logistics.packager.AbstractInventorySummary;
import net.liukrast.deployer.lib.logistics.packager.GenericUnpackingHandler;
import net.liukrast.deployer.lib.logistics.packagerLink.GenericRequestPromise;
import net.liukrast.deployer.lib.logistics.stockTicker.GenericOrder;
import net.liukrast.deployer.lib.logistics.stockTicker.GenericOrderContained;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StockInventoryType<K, V, H> {
    public final SimpleRegistry<Block, GenericUnpackingHandler<V>> registry = SimpleRegistry.create();
    public GenericUnpackingHandler<V> defaultUnpackProcedure = (level, pos, state, side, items, orderContext, simulate) -> {
        BlockEntity targetBE = level.getBlockEntity(pos);
        if (targetBE == null) {
            return false;
        }
        Object targetInv = level.getCapability(this.getBlockCapability(), pos, state, targetBE, null);
        if (targetInv == null) {
            return false;
        }
        if (!simulate) {
            for (Object itemStack : items) {
                this.insertItemStacked(targetInv, this.valueHandler().copy(itemStack), false);
            }
            return true;
        }
        IStorageHandler storageHandler = this.storageHandler();
        IValueHandler<K, Object, H> valueHandler = this.valueHandler();
        for (int slot = 0; slot < storageHandler.getSlots(targetInv); ++slot) {
            Object itemInSlot = storageHandler.getStackInSlot(targetInv, slot);
            for (int boxSlot = 0; boxSlot < items.size(); ++boxSlot) {
                Object toInsert = items.get(boxSlot);
                if (valueHandler.isEmpty(toInsert) || valueHandler.getCount(storageHandler.setInSlot(targetInv, slot, toInsert, true)) == valueHandler.getCount(toInsert)) continue;
                if (valueHandler.isEmpty(itemInSlot)) {
                    int maxStackSize = storageHandler.maxCountPerSlot();
                    if (maxStackSize < valueHandler.getCount(toInsert)) {
                        valueHandler.shrink(toInsert, maxStackSize);
                        toInsert = valueHandler.copyWithCount(toInsert, maxStackSize);
                    } else {
                        items.set(boxSlot, valueHandler.empty());
                    }
                    itemInSlot = toInsert;
                    storageHandler.insertItem(targetInv, slot, toInsert, simulate);
                    continue;
                }
                if (!valueHandler.equalsIgnoreCount(toInsert, itemInSlot)) continue;
                int added = valueHandler.getCount(toInsert) - valueHandler.getCount(storageHandler.insertItem(targetInv, slot, toInsert, simulate));
                items.set(boxSlot, valueHandler.copyWithCount(toInsert, valueHandler.getCount(toInsert) - added));
            }
        }
        for (Object stack : items) {
            if (valueHandler.isEmpty(stack)) continue;
            return false;
        }
        return true;
    };

    protected StockInventoryType() {
    }

    @NotNull
    public abstract IValueHandler<K, V, H> valueHandler();

    @NotNull
    public abstract IStorageHandler<K, V, H> storageHandler();

    @NotNull
    public abstract INetworkHandler<K, V, H> networkHandler();

    @NotNull
    public abstract IPackageHandler<K, V, H> packageHandler();

    @NotNull
    public abstract ItemStack getIcon();

    public abstract BlockCapability<H, @Nullable Direction> getBlockCapability();

    private V insertItemStacked(H inventory, V stack, boolean simulate) {
        IValueHandler<K, V, H> valueHandler = this.valueHandler();
        IStorageHandler<K, V, H> storageHandler = this.storageHandler();
        if (inventory != null && !valueHandler.isEmpty(stack)) {
            V slot;
            int i;
            if (!valueHandler.isStackable(stack)) {
                return this.insertItem(inventory, stack, simulate);
            }
            int sizeInventory = storageHandler.getSlots(inventory);
            for (i = 0; !(i >= sizeInventory || valueHandler.equalsIgnoreCount(slot = storageHandler.getStackInSlot(inventory, i), stack) && valueHandler.isEmpty(stack = storageHandler.insertItem(inventory, i, stack, simulate))); ++i) {
            }
            if (!valueHandler.isEmpty(stack)) {
                for (i = 0; !(i >= sizeInventory || valueHandler.isEmpty(storageHandler.getStackInSlot(inventory, i)) && valueHandler.isEmpty(stack = storageHandler.insertItem(inventory, i, stack, simulate))); ++i) {
                }
            }
            return stack;
        }
        return stack;
    }

    private V insertItem(H dest, V stack, boolean simulate) {
        IValueHandler<K, V, H> valueHandler = this.valueHandler();
        IStorageHandler<K, V, H> storageHandler = this.storageHandler();
        if (dest != null && !valueHandler.isEmpty(stack)) {
            for (int i = 0; i < storageHandler.getSlots(dest); ++i) {
                if (!valueHandler.isEmpty(stack = storageHandler.insertItem(dest, i, stack, simulate))) continue;
                return valueHandler.empty();
            }
            return stack;
        }
        return stack;
    }

    public static abstract class IValueHandler<K, V, H> {
        private final Codec<V> codec;
        private final Codec<GenericOrder<V>> orderCodec;
        private final Codec<GenericOrderContained<V>> orderContainedCodec;
        private final StreamCodec<? super RegistryFriendlyByteBuf, V> streamCodec;
        private final StreamCodec<RegistryFriendlyByteBuf, GenericOrder<V>> orderStreamCodec;
        private final StreamCodec<RegistryFriendlyByteBuf, GenericOrderContained<V>> orderContainedStreamCodec;

        public IValueHandler(Codec<V> codec, StreamCodec<? super RegistryFriendlyByteBuf, V> streamCodec) {
            this(codec, GenericOrder::simpleCodec, GenericOrderContained::fromOrderCodec, streamCodec, GenericOrder::simpleStreamCodec, GenericOrderContained::fromOrderStreamCodec);
        }

        public IValueHandler(Codec<V> codec, Function<Codec<V>, Codec<GenericOrder<V>>> orderFactory, BiFunction<Codec<GenericOrder<V>>, Codec<V>, Codec<GenericOrderContained<V>>> orderContainedFactory, StreamCodec<? super RegistryFriendlyByteBuf, V> streamCodec, Function<StreamCodec<? super RegistryFriendlyByteBuf, V>, StreamCodec<RegistryFriendlyByteBuf, GenericOrder<V>>> orderStreamFactory, Function<StreamCodec<RegistryFriendlyByteBuf, GenericOrder<V>>, StreamCodec<RegistryFriendlyByteBuf, GenericOrderContained<V>>> orderContainedStreamFactory) {
            this.codec = codec;
            this.orderCodec = orderFactory.apply(codec);
            this.orderContainedCodec = orderContainedFactory.apply(this.orderCodec, codec);
            this.streamCodec = streamCodec;
            this.orderStreamCodec = orderStreamFactory.apply(streamCodec);
            this.orderContainedStreamCodec = orderContainedStreamFactory.apply(this.orderStreamCodec);
        }

        public Codec<V> codec() {
            return this.codec;
        }

        public Codec<GenericOrder<V>> orderCodec() {
            return this.orderCodec;
        }

        public Codec<GenericOrderContained<V>> orderContainedCodec() {
            return this.orderContainedCodec;
        }

        public StreamCodec<? super RegistryFriendlyByteBuf, V> streamCodec() {
            return this.streamCodec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, GenericOrder<V>> orderStreamCodec() {
            return this.orderStreamCodec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, GenericOrderContained<V>> orderContainedStreamCodec() {
            return this.orderContainedStreamCodec;
        }

        public abstract K fromValue(V var1);

        public abstract boolean equalsIgnoreCount(V var1, V var2);

        public abstract boolean test(FilterItemStack var1, Level var2, V var3);

        public abstract int getCount(V var1);

        public abstract void setCount(V var1, int var2);

        public abstract boolean isEmpty(V var1);

        public abstract V create(K var1, int var2);

        public abstract void shrink(V var1, int var2);

        public abstract V copyWithCount(V var1, int var2);

        public abstract V copy(V var1);

        public abstract boolean isStackable(V var1);

        public abstract V empty();
    }

    public static interface IStorageHandler<K, V, H> {
        public int getSlots(H var1);

        public V getStackInSlot(H var1, int var2);

        public int maxCountPerSlot();

        public V extract(H var1, V var2, boolean var3);

        public int fill(H var1, V var2, boolean var3);

        public V setInSlot(H var1, int var2, V var3, boolean var4);

        public boolean isBulky(K var1);

        public H create(int var1);

        public int getMaxPackageSlots();

        public V insertItem(H var1, int var2, V var3, boolean var4);
    }

    public record OrderRenderData(int x, int y, int itemsX, int itemsY, int rowHeight, int colWidth, int orderY, int cols, Couple<Integer> hoveredSlot, PoseStack ms) {
    }

    public record CategoryRenderData(int x, int y, int itemsX, int itemsY, int categoryY, int rowHeight, int colWidth, int cols, List<StockKeeperRequestScreen.CategoryEntry> categories, float currentScroll, int windowHeight, Couple<Integer> hoveredSlot, int categoryIndex, PoseStack ms, Font font) {
    }

    public static interface IPackageHandler<K, V, H> {
        public void setBoxContent(ItemStack var1, H var2);

        public ItemStack getRandomBox();

        public H getContents(ItemStack var1);

        public DataComponentType<GenericPackageOrderData<V>> packageOrderData();

        public DataComponentType<GenericOrderContained<V>> packageOrderContext();

        default public ItemStack containing(H handler) {
            ItemStack box = this.getRandomBox();
            this.setBoxContent(box, handler);
            return box;
        }

        public int clickAmount(boolean var1, boolean var2, boolean var3);

        public int scrollAmount(boolean var1, boolean var2, boolean var3);

        default public boolean shouldRenderSearchBar() {
            return true;
        }

        public boolean matchesModSearch(V var1, String var2);

        public boolean matchesTagSearch(V var1, String var2);

        public boolean matchesSearch(V var1, String var2);

        public void renderCategory(GuiGraphics var1, float var2, int var3, int var4, List<V> var5, List<V> var6, AbstractInventorySummary<K, V> var7, CategoryRenderData var8);

        public void renderOrderedItems(GuiGraphics var1, float var2, int var3, int var4, List<V> var5, AbstractInventorySummary<K, V> var6, OrderRenderData var7);

        public void renderTooltip(GuiGraphics var1, int var2, int var3, float var4, V var5, Font var6, boolean var7);

        default public void setOrder(ItemStack box, int orderId, int linkIndex, boolean isFinalLink, int fragmentIndex, boolean isFinal, @Nullable GenericOrderContained<V> orderContext) {
            GenericPackageOrderData<V> order = new GenericPackageOrderData<V>(orderId, linkIndex, isFinalLink, fragmentIndex, isFinal, orderContext);
            box.set(this.packageOrderData(), order);
        }

        public void appendHoverText(ItemStack var1, Item.TooltipContext var2, List<Component> var3, TooltipFlag var4, H var5);

        default public int getColWidth() {
            return 20;
        }

        default public int getRowHeight() {
            return 20;
        }
    }

    public static interface INetworkHandler<K, V, H> {
        public Codec<GenericRequestPromise<V>> requestCodec();

        public AbstractInventorySummary<K, V> createSummary();

        public AbstractInventorySummary<K, V> empty();

        public DataComponentType<? super GenericPackageOrderData<V>> getComponent();
    }
}

