/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.deployer.lib.logistics.board.connection;

import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.liukrast.deployer.lib.DeployerConstants;
import net.liukrast.deployer.lib.logistics.board.connection.ConnectionExtra;
import net.liukrast.deployer.lib.registry.DeployerRegistries;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class PanelConnection<T> {
    private final Map<Block, ConnectionExtra<T>> extraConnections = new HashMap<Block, ConnectionExtra<T>>();
    private final Function<FactoryPanelBehaviour, T> defaultProvider;

    public PanelConnection(Function<FactoryPanelBehaviour, T> defaultProvider) {
        this.defaultProvider = defaultProvider;
    }

    public void addListener(ConnectionExtra<T> supplier, Block ... validBlocks) {
        if (validBlocks.length == 0) {
            DeployerConstants.LOGGER.error("Registered panel connection listener without any blocks. {}", (Object)this);
        }
        for (Block block : validBlocks) {
            this.extraConnections.put(block, supplier);
        }
    }

    public static Direction makeContext(BlockState state) {
        if (state.hasProperty((Property)BlockStateProperties.ATTACH_FACE)) {
            AttachFace attachFace = (AttachFace)state.getValue((Property)BlockStateProperties.ATTACH_FACE);
            return switch (attachFace) {
                default -> throw new MatchException(null, null);
                case AttachFace.CEILING -> Direction.DOWN;
                case AttachFace.FLOOR -> Direction.UP;
                case AttachFace.WALL -> (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            };
        }
        if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            return (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        }
        if (state.hasProperty((Property)BlockStateProperties.FACING)) {
            return (Direction)state.getValue((Property)BlockStateProperties.FACING);
        }
        return null;
    }

    public ConnectionExtra<T> getListener(Block block) {
        return this.extraConnections.get(block);
    }

    public T getDefault(FactoryPanelBehaviour behaviour) {
        return this.defaultProvider.apply(behaviour);
    }

    public String toString() {
        ResourceLocation id = DeployerRegistries.PANEL_CONNECTION.getKey((Object)this);
        return id == null ? "unregistered" : id.toString();
    }
}

