/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.deployer.lib.logistics.board.cache;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import java.util.Map;
import net.createmod.catnip.platform.CatnipServices;
import net.liukrast.deployer.lib.DeployerConstants;
import net.liukrast.deployer.lib.logistics.board.cache.PanelCacheUpdatePacket;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public interface CacheContainer<T> {
    public Codec<T> cacheCodec();

    public Map<BlockPos, T> cacheMap();

    default public void setCache(CompoundTag tag, DynamicOps<Tag> dynamicOps) {
        Map cache = this.cacheMap();
        Codec<T> codec = this.cacheCodec();
        cache.clear();
        for (String key : tag.getAllKeys()) {
            String[] t = key.split(",");
            try {
                BlockPos pos = new BlockPos(Integer.parseInt(t[0]), Integer.parseInt(t[1]), Integer.parseInt(t[2]));
                codec.parse(dynamicOps, (Object)tag.get(key)).resultOrPartial(arg_0 -> ((Logger)DeployerConstants.LOGGER).error(arg_0)).ifPresent(r -> cache.put(pos, r));
            }
            catch (NumberFormatException e) {
                DeployerConstants.LOGGER.error("Unable to parse compound tag {}", (Object)tag.get(key), (Object)e);
            }
        }
    }

    default public void getCache(CompoundTag tag, DynamicOps<Tag> dynamicOps) {
        Map<BlockPos, T> cache = this.cacheMap();
        Codec<T> codec = this.cacheCodec();
        for (BlockPos pos : cache.keySet()) {
            String key = pos.getX() + "," + pos.getY() + "," + pos.getZ();
            codec.encodeStart(dynamicOps, cache.get(pos)).resultOrPartial(arg_0 -> ((Logger)DeployerConstants.LOGGER).error(arg_0)).ifPresent(tag1 -> tag.put(key, tag1));
        }
    }

    default public void sendCache(FactoryPanelBehaviour behaviour) {
        Level level = behaviour.blockEntity.getLevel();
        if (level == null || level.isClientSide) {
            return;
        }
        CompoundTag tag = new CompoundTag();
        this.getCache(tag, (DynamicOps<Tag>)level.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE));
        CatnipServices.NETWORK.sendToClientsTrackingChunk((ServerLevel)level, new ChunkPos(behaviour.blockEntity.getBlockPos()), (CustomPacketPayload)new PanelCacheUpdatePacket(behaviour.getPanelPosition(), tag));
    }
}

