/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.deployer.lib.logistics.board;

import com.google.common.collect.Lists;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelConfigurationPacket;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelConnectionHandler;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.HashMap;
import java.util.List;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.platform.CatnipServices;
import net.liukrast.deployer.lib.DeployerConstants;
import net.liukrast.deployer.lib.logistics.board.AbstractPanelBehaviour;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicPanelScreen<T extends AbstractPanelBehaviour>
extends AbstractSimiScreen {
    @ApiStatus.Internal
    public static final ResourceLocation TEXTURE = DeployerConstants.id("textures/gui/generic_gauge.png", new Object[0]);
    public final T behaviour;
    private boolean sendReset;

    public BasicPanelScreen(T behaviour) {
        this(((AbstractPanelBehaviour)((Object)behaviour)).getDisplayName(), behaviour);
    }

    public BasicPanelScreen(Component component, T behaviour) {
        super(component);
        this.behaviour = behaviour;
    }

    public int getWindowWidth() {
        return 0;
    }

    public int getWindowHeight() {
        return 0;
    }

    public ResourceLocation getBackgroundTexture() {
        return TEXTURE;
    }

    protected void init() {
        this.setWindowSize(this.getWindowWidth() + 106, this.getWindowHeight() + 46);
        int sizeX = this.windowWidth;
        int sizeY = this.windowHeight;
        super.init();
        this.clearWidgets();
        int x = this.guiLeft;
        int y = this.guiTop;
        assert (this.minecraft != null);
        IconButton confirmButton = new IconButton(x + sizeX - 25, y + sizeY - 24, (ScreenElement)AllIcons.I_CONFIRM);
        confirmButton.withCallback(this::onConfirm);
        confirmButton.setToolTip((Component)CreateLang.translate((String)"gui.factory_panel.save_and_close", (Object[])new Object[0]).component());
        this.addRenderableWidget((GuiEventListener)confirmButton);
        IconButton deleteButton = new IconButton(x + sizeX - 47, y + sizeY - 24, (ScreenElement)AllIcons.I_TRASH);
        deleteButton.withCallback(() -> {
            this.sendReset = true;
            this.minecraft.setScreen(null);
        });
        deleteButton.setToolTip((Component)CreateLang.translate((String)"gui.factory_panel.reset", (Object[])new Object[0]).component());
        this.addRenderableWidget((GuiEventListener)deleteButton);
        IconButton newInputButton = new IconButton(x + 7, y + sizeY - 24, (ScreenElement)AllIcons.I_ADD);
        newInputButton.withCallback(() -> {
            FactoryPanelConnectionHandler.startConnection(this.behaviour);
            this.minecraft.setScreen(null);
        });
        newInputButton.setToolTip((Component)CreateLang.translate((String)"gui.factory_panel.connect_input", (Object[])new Object[0]).component());
        this.addRenderableWidget((GuiEventListener)newInputButton);
        IconButton relocateButton = new IconButton(x + 29, y + sizeY - 24, (ScreenElement)AllIcons.I_MOVE_GAUGE);
        relocateButton.withCallback(() -> {
            FactoryPanelConnectionHandler.startRelocating(this.behaviour);
            this.minecraft.setScreen(null);
        });
        relocateButton.setToolTip((Component)CreateLang.translate((String)"gui.factory_panel.relocate", (Object[])new Object[0]).component());
        this.addRenderableWidget((GuiEventListener)relocateButton);
    }

    public void onConfirm() {
        assert (this.minecraft != null);
        this.minecraft.setScreen(null);
    }

    protected void renderWindow(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int r;
        int x = this.guiLeft;
        int y = this.guiTop;
        ResourceLocation bg = this.getBackgroundTexture();
        graphics.drawCenteredString(this.font, this.title, x + this.windowWidth / 2, y + 4, 4013128);
        graphics.blit(bg, x, y, 0, 0, 53, 16);
        graphics.blit(bg, x + this.windowWidth - 106 + 53, y, 139, 0, 53, 16);
        graphics.blit(bg, x, y + this.windowHeight - 46 + 15, 0, 56, 53, 32);
        graphics.blit(bg, x + this.windowWidth - 106 + 53, y + this.windowHeight - 46 + 15, 139, 56, 60, 32);
        if (this.windowWidth > 106) {
            r = this.windowWidth - 106;
            int r1 = r - 3;
            int step = 0;
            if (r > 1) {
                graphics.blit(bg, x + this.windowWidth - 106 + 52, y + this.windowHeight - 46 + 15, 138, 56, 1, 32);
            }
            graphics.blit(bg, x + 53, y + this.windowHeight - 46 + 15, 53, 56, 2, 32);
            while (r > 0 || r1 > 0) {
                if (r > 0) {
                    graphics.blit(bg, x + 53 + step * 86, y, 53, 0, Math.min(r, 86), 16);
                }
                if (r1 > 0) {
                    graphics.blit(bg, x + 55 + step * 83, y + this.windowHeight - 46 + 15, 55, 56, Math.min(r1, 83), 32);
                }
                ++step;
                r -= 86;
                r1 -= 83;
            }
        }
        if (this.windowHeight > 47) {
            int r1;
            int step1;
            r = this.windowHeight - 47;
            int step = 0;
            graphics.blit(bg, x, y + 16, 0, 16, 53, Math.min(r, 40));
            graphics.blit(bg, x + this.windowWidth - 106 + 53, y + 16, 139, 16, 53, Math.min(r, 40));
            if (this.windowWidth > 106) {
                step1 = 0;
                for (r1 = this.windowWidth - 106; r1 > 0; r1 -= 86) {
                    graphics.blit(bg, x + 53 + step1 * 86, y + 16, 53, 16, Math.min(r1, 86), Math.min(r, 40));
                    ++step1;
                }
            }
            r -= 40;
            while (r > 0) {
                graphics.blit(bg, x, y + 56 + step * 36, 0, 20, 53, Math.min(r, 36));
                graphics.blit(bg, x + this.windowWidth - 106 + 53, y + 56 + step * 36, 139, 20, 53, Math.min(r, 36));
                step1 = 0;
                for (r1 = this.windowWidth - 106; r1 > 0; r1 -= 86) {
                    graphics.blit(bg, x + 53 + step1 * 86, y + 56 + step * 36, 53, 20, Math.min(r1, 86), Math.min(r, 36));
                    ++step1;
                }
                ++step;
                r -= 36;
            }
        }
        GuiGameElement.of((ItemStack)((AbstractPanelBehaviour)((Object)this.behaviour)).getItem().getDefaultInstance()).scale(4.0).at(0.0f, 0.0f, -200.0f).render(graphics, x + this.windowWidth, y + this.windowHeight - 48);
    }

    public void removed() {
        this.sendIt(null);
        super.removed();
    }

    private void sendIt(@Nullable FactoryPanelPosition toRemove) {
        FactoryPanelPosition pos = this.behaviour.getPanelPosition();
        FactoryPanelConfigurationPacket packet = new FactoryPanelConfigurationPacket(pos, "", new HashMap(), (List)Lists.newArrayList(), 0, 0, toRemove, false, this.sendReset, false);
        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)packet);
    }
}

