/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.deployer.lib.logistics;

import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBlockItem;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public interface LogisticallyLinked {
    public static void appendHoverText(ItemStack stack, List<Component> tooltipComponents) {
        UUID uuid = LogisticallyLinkedBlockItem.networkFromStack((ItemStack)stack);
        if (uuid == null) {
            return;
        }
        CreateLang.translate((String)"logistically_linked.tooltip", (Object[])new Object[0]).style(ChatFormatting.GOLD).addTo(tooltipComponents);
        CreateLang.translate((String)"logistically_linked.tooltip_clear", (Object[])new Object[0]).style(ChatFormatting.GRAY).addTo(tooltipComponents);
    }

    @NotNull
    public static InteractionResult useOn(@NotNull UseOnContext pContext, Function<UseOnContext, InteractionResult> super$useOn) {
        ItemStack stack = pContext.getItemInHand();
        BlockPos pos = pContext.getClickedPos();
        Level level = pContext.getLevel();
        Player player = pContext.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (player.isShiftKeyDown()) {
            return super$useOn.apply(pContext);
        }
        LogisticallyLinkedBehaviour link = (LogisticallyLinkedBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)pos, (BehaviourType)LogisticallyLinkedBehaviour.TYPE);
        boolean tuned = LogisticallyLinkedBlockItem.isTuned((ItemStack)stack);
        if (link != null) {
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (!link.mayInteractMessage(player)) {
                return InteractionResult.SUCCESS;
            }
            LogisticallyLinkedBlockItem.assignFrequency((ItemStack)stack, (Player)player, (UUID)link.freqId);
            return InteractionResult.SUCCESS;
        }
        InteractionResult useOn = super$useOn.apply(pContext);
        if (level.isClientSide || useOn == InteractionResult.FAIL) {
            return useOn;
        }
        player.displayClientMessage((Component)(tuned ? CreateLang.translateDirect((String)"logistically_linked.connected", (Object[])new Object[0]) : CreateLang.translateDirect((String)"logistically_linked.new_network_started", (Object[])new Object[0])), true);
        return useOn;
    }
}

