/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.deployer.lib.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.ClientTooltipFlag;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix4f;

public class GuiRenderingHelper {
    private GuiRenderingHelper() {
    }

    public static void renderFluid(GuiGraphics graphics, FluidStack stack, int x, int y, int width, int height) {
        RenderSystem.enableBlend();
        Fluid fluid = stack.getFluid();
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation fluidStill = renderProperties.getStillTexture(stack);
        TextureAtlasSprite texture = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(fluidStill);
        if (texture == null) {
            return;
        }
        if (texture.atlasLocation() == MissingTextureAtlasSprite.getLocation()) {
            return;
        }
        int fluidColor = renderProperties.getTintColor(stack);
        long amount = stack.getAmount();
        long scaledAmount = amount * (long)height / 1000L;
        if (amount > 0L && scaledAmount < 1L) {
            scaledAmount = 1L;
        }
        if (scaledAmount > (long)height) {
            scaledAmount = height;
        }
        GuiRenderingHelper.drawTiledSprite(graphics, width, height, fluidColor, scaledAmount, texture, x, y);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private static void drawTiledSprite(GuiGraphics guiGraphics, int tiledWidth, int tiledHeight, int color, long scaledAmount, TextureAtlasSprite sprite, int posX, int posY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        Matrix4f matrix = guiGraphics.pose().last().pose();
        GuiRenderingHelper.setGLColorFromInt(color);
        int xTileCount = tiledWidth / 16;
        int xRemainder = tiledWidth - xTileCount * 16;
        long yTileCount = scaledAmount / 16L;
        long yRemainder = scaledAmount - yTileCount * 16L;
        int yStart = tiledHeight + posY;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            int yTile = 0;
            while ((long)yTile <= yTileCount) {
                int width = xTile == xTileCount ? xRemainder : 16;
                long height = (long)yTile == yTileCount ? yRemainder : 16L;
                int x = posX + xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (width > 0 && height > 0L) {
                    long maskTop = 16L - height;
                    int maskRight = 16 - width;
                    GuiRenderingHelper.drawTextureWithMasking(matrix, x, y, sprite, maskTop, maskRight, 100.0f);
                }
                ++yTile;
            }
        }
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    private static void drawTextureWithMasking(Matrix4f matrix, float xCoord, float yCoord, TextureAtlasSprite textureSprite, long maskTop, long maskRight, float zLevel) {
        float uMin = textureSprite.getU0();
        float uMax = textureSprite.getU1();
        float vMin = textureSprite.getV0();
        float vMax = textureSprite.getV1();
        uMax -= (float)maskRight / 16.0f * (uMax - uMin);
        vMax -= (float)maskTop / 16.0f * (vMax - vMin);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex(matrix, xCoord, yCoord + 16.0f, zLevel).setUv(uMin, vMax);
        bufferBuilder.addVertex(matrix, xCoord + 16.0f - (float)maskRight, yCoord + 16.0f, zLevel).setUv(uMax, vMax);
        bufferBuilder.addVertex(matrix, xCoord + 16.0f - (float)maskRight, yCoord + (float)maskTop, zLevel).setUv(uMax, vMin);
        bufferBuilder.addVertex(matrix, xCoord, yCoord + (float)maskTop, zLevel).setUv(uMin, vMin);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
    }

    public static void renderTooltip(GuiGraphics graphics, FluidStack stack, int mouseX, int mouseY, Font font) {
        ResourceLocation id;
        ArrayList<Object> tooltip = new ArrayList<Object>();
        tooltip.add(stack.getHoverName());
        TooltipFlag flag = ClientTooltipFlag.of((TooltipFlag)(Minecraft.getInstance().options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
        if (flag.isAdvanced() && (id = BuiltInRegistries.FLUID.getKey((Object)stack.getFluid())) != BuiltInRegistries.FLUID.getDefaultKey()) {
            MutableComponent advancedId = Component.literal((String)id.toString()).withStyle(ChatFormatting.DARK_GRAY);
            tooltip.add(advancedId);
        }
        graphics.renderTooltip(font, tooltip, Optional.empty(), mouseX, mouseY);
    }
}

