/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.deployer.lib.blockEntity.behaviour;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.CapManipulationBehaviourBase;
import net.liukrast.deployer.lib.blockEntity.behaviour.VersionedWrapper;

public class VersionedTrackerBehaviour<A, B extends CapManipulationBehaviourBase<?, ?>>
extends BlockEntityBehaviour {
    public static final BehaviourType<VersionedTrackerBehaviour<?, ?>> TYPE = new BehaviourType();
    private int ignoredId;
    private int ignoredVersion;

    public VersionedTrackerBehaviour(SmartBlockEntity be) {
        super(be);
        this.reset();
    }

    public boolean stillWaiting(CapManipulationBehaviourBase<A, B> behaviour) {
        return behaviour.hasInventory() && this.stillWaiting(behaviour.getInventory());
    }

    public boolean stillWaiting(A handler) {
        if (handler instanceof VersionedWrapper) {
            VersionedWrapper viw = (VersionedWrapper)handler;
            return viw.getId() == this.ignoredId && viw.getVersion() == this.ignoredVersion;
        }
        return false;
    }

    public void awaitNewVersion(CapManipulationBehaviourBase<A, B> behaviour) {
        if (behaviour.hasInventory()) {
            this.awaitNewVersion(behaviour.getInventory());
        }
    }

    public void awaitNewVersion(A handler) {
        if (handler instanceof VersionedWrapper) {
            VersionedWrapper viw = (VersionedWrapper)handler;
            this.ignoredId = viw.getId();
            this.ignoredVersion = viw.getVersion();
        }
    }

    public void reset() {
        this.ignoredVersion = -1;
        this.ignoredId = -1;
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }
}

