package net.liukrast.deployer.lib.mixin;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import net.liukrast.deployer.lib.DeployerConstants;
import net.liukrast.deployer.lib.logistics.board.AbstractPanelBehaviour;
import net.liukrast.deployer.lib.mixinExtensions.FPBEExtension;
import net.liukrast.deployer.lib.registry.DeployerRegistries;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;

import static com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock.PanelSlot;

@Mixin(FactoryPanelBlockEntity.class)
public abstract class FactoryPanelBlockEntityMixin extends SmartBlockEntity implements FPBEExtension {

    @Shadow public EnumMap<PanelSlot, FactoryPanelBehaviour> panels;

    @Unique
    private final List<ItemStack> deployer$extraDrops = new ArrayList<>();

    @Override
    public List<ItemStack> deployer$getExtraDrops() {
        return deployer$extraDrops;
    }

    public FactoryPanelBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Inject(method = "read", at = @At("HEAD"))
    private void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket, CallbackInfo ci) {
        var instance = FactoryPanelBlockEntity.class.cast(this);
        if(!tag.contains("CustomPanels")) return;
        var customPanels = tag.getCompound("CustomPanels");
        for(PanelSlot slot : PanelSlot.values()) {
            String key = CreateLang.asId(slot.name());
            if(customPanels.contains(key)) {
                ResourceLocation id = ResourceLocation.parse(customPanels.getString(key));
                var type = DeployerRegistries.PANEL.get(id);
                if(type == null) {
                    DeployerConstants.LOGGER.error("Unable to find panel registry key {} for panel slot {} at pos {}", id, slot, getBlockPos());
                    continue;
                }
                var current = panels.get(slot);
                if(current != null && type.asClass().equals(current.getClass())) continue; //No need to re-initialize behaviour
                var behaviour = type.create(instance, slot);
                if(behaviour == null) continue;
                panels.put(slot, behaviour);
                instance.attachBehaviourLate(behaviour);
            }
        }
    }

    @Inject(method = "destroy", at = @At("HEAD"))
    private void destroy(CallbackInfo ci) {
        //var instance = FactoryPanelBlockEntity.class.cast(this);
        deployer$extraDrops.clear();
        for(var panel : panels.values()) {
            if(!panel.active) continue;
            deployer$extraDrops.add(panel instanceof AbstractPanelBehaviour ab ? ab.getItem().getDefaultInstance() : AllBlocks.FACTORY_GAUGE.asStack());
        }
    }
}
