package net.liukrast.deployer.lib.logistics.board.renderer;

import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBox;
import com.simibubi.create.foundation.utility.CreateLang;
import net.createmod.catnip.outliner.Outliner;
import net.liukrast.deployer.lib.logistics.board.ScrollOptionPanelBehaviour;
import net.liukrast.deployer.lib.logistics.board.ScrollPanelBehaviour;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;

import java.util.ArrayList;
import java.util.List;

@ApiStatus.Internal
public class ScrollPanelRenderer {

    /**
     * Updates the highlighting and hover tooltip for all active scroll panel behaviors
     * that the player is currently looking at.
     * Checks if the block is a SmartBlockEntity, iterates its behaviors, and displays
     * outlines and tooltips for panels that are hit and active.
     */
    public static void tick() {
        Minecraft mc = Minecraft.getInstance();
        HitResult target = mc.hitResult;
        if (!(target instanceof BlockHitResult result))
            return;

        ClientLevel world = mc.level;
        BlockPos pos = result.getBlockPos();
        Direction face = result.getDirection();
        boolean highlightFound = false;

        assert world != null;
        if (!(world.getBlockEntity(pos) instanceof SmartBlockEntity sbe))
            return;

        for (BlockEntityBehaviour blockEntityBehaviour : sbe.getAllBehaviours()) {
            if (!(blockEntityBehaviour instanceof ScrollPanelBehaviour behaviour))
                continue;

            if (!behaviour.isActive()) {
                Outliner.getInstance().remove(behaviour);
                continue;
            }

            assert mc.player != null;
            ItemStack mainHandItem = mc.player.getItemInHand(InteractionHand.MAIN_HAND);
            boolean clipboard = behaviour.bypassesInput(mainHandItem);
            boolean highlight = behaviour.testHit(target.getLocation()) && !clipboard && !highlightFound;

            addBox(pos, face, behaviour, highlight);


            if (!highlight)
                continue;

            highlightFound = true;
            List<MutableComponent> tip = new ArrayList<>();
            tip.add(behaviour.label.copy());
            tip.add(CreateLang.translateDirect("gui.value_settings.hold_to_edit"));
            CreateClient.VALUE_SETTINGS_HANDLER.showHoverTip(tip);
        }
    }

    /**
     * Creates and displays an outline box for the given scroll panel behavior.
     * Chooses between text or icon display depending on the behavior type,
     * sets passive/wide outline properties, and highlights the relevant block face.
     *
     * @param pos the block position of the panel
     * @param face the block face currently being targeted
     * @param behaviour the scroll panel behavior to render
     * @param highlight whether this panel should be highlighted
     */
    protected static void addBox(BlockPos pos, Direction face, ScrollPanelBehaviour behaviour,
                                 boolean highlight) {
        AABB bb = new AABB(Vec3.ZERO, Vec3.ZERO).inflate(.5f)
                .contract(0, 0, -.5f)
                .move(0, 0, -.125f);
        Component label = behaviour.label;
        ValueBox box;
        if (behaviour instanceof ScrollOptionPanelBehaviour) {
            box = new ValueBox.IconValueBox(label, ((ScrollOptionPanelBehaviour<?>) behaviour).getIconForSelected(), bb, pos);
        } else box = new ValueBox.TextValueBox(label, bb, pos, Component.literal(behaviour.formatValue()));

        box.passive(!highlight)
                .wideOutline();

        Outliner.getInstance().showOutline(behaviour, box.transform(behaviour.getSlotPositioning()))
                .highlightFace(face);
    }

}
