/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.deployer.lib.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.simibubi.create.content.logistics.packagerLink.RequestPromiseQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.codecs.CatnipCodecUtils;
import net.liukrast.deployer.lib.logistics.packager.StockInventoryType;
import net.liukrast.deployer.lib.logistics.packagerLink.GenericRequestPromise;
import net.liukrast.deployer.lib.mixinExtensions.RPQExtension;
import net.liukrast.deployer.lib.registry.DeployerRegistries;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RequestPromiseQueue.class})
public class RequestPromiseQueueMixin
implements RPQExtension {
    @Shadow
    private Runnable onChanged;
    @Unique
    private final Map<StockInventoryType<?, ?, ?>, Map<?, List<GenericRequestPromise<?>>>> deployer$promisesGeneric = new HashMap();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(Runnable onChanged, CallbackInfo ci) {
        for (StockInventoryType type : DeployerRegistries.STOCK_INVENTORY) {
            this.deployer$promisesGeneric.put(type, new IdentityHashMap());
        }
    }

    @Override
    public <K, V, H> void deployer$add(StockInventoryType<K, V, H> type, GenericRequestPromise<V> promise) {
        this.deployer$promisesGeneric.get(type).computeIfAbsent(type.valueHandler().fromValue(promise.promisedStack), $ -> new LinkedList()).add(promise);
        this.onChanged.run();
    }

    @Override
    public <K, V, H> int deployer$getTotalPromisedAndRemoveExpired(StockInventoryType<K, V, H> type, V stack, int expiryTime) {
        int promised = 0;
        List<GenericRequestPromise<?>> list = this.deployer$promisesGeneric.get(type).get(type.valueHandler().fromValue(stack));
        if (list == null) {
            return promised;
        }
        Iterator<GenericRequestPromise<?>> iterator = list.iterator();
        while (iterator.hasNext()) {
            GenericRequestPromise<?> promise = iterator.next();
            if (!type.valueHandler().equalsIgnoreCount(promise.promisedStack, stack)) continue;
            if (expiryTime != -1 && promise.ticksExisted >= expiryTime) {
                iterator.remove();
                this.onChanged.run();
                continue;
            }
            promised += type.valueHandler().getCount(promise.promisedStack);
        }
        return promised;
    }

    @Override
    public <K, V, H> void deployer$forceClear(StockInventoryType<K, V, H> type, V stack) {
        List<GenericRequestPromise<?>> list = this.deployer$promisesGeneric.get(type).get(type.valueHandler().fromValue(stack));
        if (list == null) {
            return;
        }
        Iterator<GenericRequestPromise<?>> iterator = list.iterator();
        while (iterator.hasNext()) {
            GenericRequestPromise<?> promise = iterator.next();
            if (!type.valueHandler().equalsIgnoreCount(promise.promisedStack, stack)) continue;
            iterator.remove();
            this.onChanged.run();
        }
        if (list.isEmpty()) {
            this.deployer$promisesGeneric.get(type).remove(type.valueHandler().fromValue(stack));
        }
    }

    @Override
    public <K, V, H> void deployer$genericEnteredSystem(StockInventoryType<K, V, H> type, V entry, int amount) {
        List<GenericRequestPromise<?>> list = this.deployer$promisesGeneric.get(type).get(type.valueHandler().fromValue(entry));
        if (list == null) {
            return;
        }
        Iterator<GenericRequestPromise<?>> iterator = list.iterator();
        while (iterator.hasNext()) {
            GenericRequestPromise<?> requestPromise = iterator.next();
            if (!type.valueHandler().equalsIgnoreCount(requestPromise.promisedStack, entry)) continue;
            int toSubtract = Math.min(amount, type.valueHandler().getCount(requestPromise.promisedStack));
            amount -= toSubtract;
            type.valueHandler().setCount(requestPromise.promisedStack, type.valueHandler().getCount(requestPromise.promisedStack) - toSubtract);
            if (type.valueHandler().getCount(requestPromise.promisedStack) <= 0) {
                iterator.remove();
                this.onChanged.run();
            }
            if (amount > 0) continue;
            break;
        }
        if (list.isEmpty()) {
            this.deployer$promisesGeneric.get(type).remove(type.valueHandler().fromValue(entry));
        }
    }

    @Override
    public <K, V, H> List<GenericRequestPromise<V>> deployer$flatten(StockInventoryType<K, V, H> type, boolean sorted) {
        ArrayList all = new ArrayList();
        this.deployer$promisesGeneric.get(type).forEach((key, list) -> all.addAll((Collection)list));
        if (sorted) {
            all.sort(GenericRequestPromise.ageComparator());
        }
        return all;
    }

    @Inject(method={"write"}, at={@At(value="RETURN")})
    private void write(HolderLookup.Provider registries, CallbackInfoReturnable<CompoundTag> cir) {
        CompoundTag tag = (CompoundTag)cir.getReturnValue();
        CompoundTag special = new CompoundTag();
        for (StockInventoryType type : DeployerRegistries.STOCK_INVENTORY) {
            special.put(DeployerRegistries.STOCK_INVENTORY.getKey((Object)type).toString(), (Tag)this.deployer$writeSingle(type, registries));
        }
        tag.put("deployer$ExtraLists", (Tag)special);
    }

    @Unique
    private <K, V, H> ListTag deployer$writeSingle(StockInventoryType<K, V, H> type, HolderLookup.Provider registries) {
        ListTag tagList = new ListTag();
        for (GenericRequestPromise<V> promise : this.deployer$flatten(type, false)) {
            tagList.add((Object)((Tag)CatnipCodecUtils.encode(type.networkHandler().requestCodec(), (HolderLookup.Provider)registries, promise).orElseThrow()));
        }
        return tagList;
    }

    @Inject(method={"read"}, at={@At(value="RETURN")})
    private static void read(CompoundTag tag, HolderLookup.Provider registries, Runnable onChanged, CallbackInfoReturnable<RequestPromiseQueue> cir) {
        CompoundTag special = tag.getCompound("deployer$ExtraLists");
        RPQExtension result = (RPQExtension)cir.getReturnValue();
        for (StockInventoryType type : DeployerRegistries.STOCK_INVENTORY) {
            ListTag tagList = special.getList(String.valueOf(DeployerRegistries.STOCK_INVENTORY.getKey((Object)type)), 0);
            RequestPromiseQueueMixin.deployer$readSingle(type, tagList, result);
        }
    }

    @Unique
    private static <K, V, H> void deployer$readSingle(StockInventoryType<K, V, H> type, ListTag tagList, RPQExtension output) {
        for (Tag tag : tagList) {
            GenericRequestPromise elem = (GenericRequestPromise)CatnipCodecUtils.decode(type.networkHandler().requestCodec(), (Tag)tag).orElseThrow();
            output.deployer$add(type, elem);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        this.deployer$promisesGeneric.forEach((a, b) -> b.forEach((c, d) -> d.forEach(GenericRequestPromise::tick)));
    }

    @ModifyReturnValue(method={"isEmpty"}, at={@At(value="RETURN")})
    private boolean isEmpty(boolean original) {
        return original && this.deployer$promisesGeneric.values().stream().allMatch(Map::isEmpty);
    }
}

