/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.deployer.lib.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.simibubi.create.content.logistics.packager.IdentifiedInventory;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.redstoneRequester.RedstoneRequesterBlockEntity;
import com.simibubi.create.content.logistics.redstoneRequester.RedstoneRequesterEffectPacket;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import com.simibubi.create.content.logistics.stockTicker.StockCheckingBlockEntity;
import java.util.HashMap;
import java.util.Map;
import net.createmod.catnip.codecs.CatnipCodecUtils;
import net.createmod.catnip.platform.CatnipServices;
import net.liukrast.deployer.lib.logistics.packager.AbstractInventorySummary;
import net.liukrast.deployer.lib.logistics.packager.StockInventoryType;
import net.liukrast.deployer.lib.logistics.stockTicker.GenericOrderContained;
import net.liukrast.deployer.lib.mixinExtensions.RRBEExtension;
import net.liukrast.deployer.lib.mixinExtensions.SCBEExtension;
import net.liukrast.deployer.lib.registry.DeployerRegistries;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RedstoneRequesterBlockEntity.class})
public abstract class RedstoneRequesterBlockEntityMixin
extends StockCheckingBlockEntity
implements RRBEExtension {
    @Shadow
    public boolean allowPartialRequests;
    @Unique
    private final Map<StockInventoryType<?, ?, ?>, GenericOrderContained<?>> deployer$encodedRequests = new HashMap();
    @Unique
    private boolean deployer$triggerRequest$local$anySucceeded;

    public RedstoneRequesterBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public <K, V, H> void deployer$setEncodedRequest(StockInventoryType<K, V, H> type, GenericOrderContained<V> encodedRequest) {
        this.deployer$encodedRequests.put(type, encodedRequest);
    }

    @Override
    public <K, V, H> GenericOrderContained<V> deployer$getEncodedRequest(StockInventoryType<K, V, H> type) {
        return this.deployer$encodedRequests.computeIfAbsent(type, t -> GenericOrderContained.empty());
    }

    @Inject(method={"triggerRequest"}, at={@At(value="HEAD")}, cancellable=true)
    private void triggerRequest(CallbackInfo ci) {
        boolean anySucceeded = false;
        for (StockInventoryType type : DeployerRegistries.STOCK_INVENTORY) {
            anySucceeded |= this.deployer$triggerRequest(type, ci);
        }
        this.deployer$triggerRequest$local$anySucceeded = anySucceeded;
    }

    @Unique
    private <K, V, H> boolean deployer$triggerRequest(StockInventoryType<K, V, H> type, CallbackInfo ci) {
        GenericOrderContained encodedRequest = this.deployer$encodedRequests.computeIfAbsent(type, t -> GenericOrderContained.empty());
        if (encodedRequest.isEmpty()) {
            return false;
        }
        boolean anySucceded = false;
        AbstractInventorySummary<K, V> summaryOfOrder = type.networkHandler().createSummary();
        encodedRequest.stacks().forEach(summaryOfOrder::add);
        AbstractInventorySummary<K, V> summary = ((SCBEExtension)((Object)this)).deployer$getAccurateSummary(type);
        for (V entry : summaryOfOrder.getStacks()) {
            Level level;
            if (summary.getCountOf(entry) >= type.valueHandler().getCount(entry)) {
                anySucceded = true;
                continue;
            }
            if (this.allowPartialRequests || !((level = this.level) instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            CatnipServices.NETWORK.sendToClientsAround(serverLevel, (Vec3i)this.worldPosition, 32.0, (CustomPacketPayload)new RedstoneRequesterEffectPacket(this.worldPosition, false));
            ci.cancel();
            return false;
        }
        return anySucceded;
    }

    @ModifyArg(method={"triggerRequest"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/redstoneRequester/RedstoneRequesterEffectPacket;<init>(Lnet/minecraft/core/BlockPos;Z)V"), index=1)
    private boolean triggerRequest(boolean original) {
        return original || this.deployer$triggerRequest$local$anySucceeded;
    }

    @ModifyExpressionValue(method={"triggerRequest"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/stockTicker/PackageOrderWithCrafts;isEmpty()Z")})
    private boolean triggerRequest$1(boolean original) {
        return original || this.deployer$triggerRequest$local$anySucceeded;
    }

    @WrapOperation(method={"triggerRequest"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/redstoneRequester/RedstoneRequesterBlockEntity;broadcastPackageRequest(Lcom/simibubi/create/content/logistics/packagerLink/LogisticallyLinkedBehaviour$RequestType;Lcom/simibubi/create/content/logistics/stockTicker/PackageOrderWithCrafts;Lcom/simibubi/create/content/logistics/packager/IdentifiedInventory;Ljava/lang/String;)Z")})
    private boolean triggerRequest(RedstoneRequesterBlockEntity instance, LogisticallyLinkedBehaviour.RequestType requestType, PackageOrderWithCrafts packageOrderWithCrafts, IdentifiedInventory identifiedInventory, String s, Operation<Boolean> original) {
        if (this.deployer$triggerRequest$local$anySucceeded) {
            return (Boolean)original.call(new Object[]{instance, requestType, packageOrderWithCrafts, identifiedInventory, s});
        }
        return ((SCBEExtension)((Object)this)).deployer$broadcastAllPackageRequest(packageOrderWithCrafts, requestType, this.deployer$encodedRequests, s);
    }

    @Inject(method={"read"}, at={@At(value="TAIL")})
    private void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket, CallbackInfo ci) {
        CompoundTag specialData = tag.getCompound("deployer$encodedRequest");
        for (String key : specialData.getAllKeys()) {
            StockInventoryType type = (StockInventoryType)DeployerRegistries.STOCK_INVENTORY.get(ResourceLocation.parse((String)key));
            if (type == null) continue;
            this.deployer$encodedRequests.put(type, CatnipCodecUtils.decode(type.valueHandler().orderContainedCodec(), (HolderLookup.Provider)registries, (Tag)specialData.getCompound(key)).orElse(GenericOrderContained.empty()));
        }
    }

    @Inject(method={"writeSafe", "write"}, at={@At(value="TAIL")})
    private void writeSafe(CallbackInfo ci, @Local(argsOnly=true) CompoundTag tag, @Local(argsOnly=true) HolderLookup.Provider registries) {
        CompoundTag specialData = new CompoundTag();
        for (Map.Entry<StockInventoryType<?, ?, ?>, GenericOrderContained<?>> entry : this.deployer$encodedRequests.entrySet()) {
            this.deployer$encode(entry.getKey(), entry.getValue(), specialData, registries);
        }
        tag.put("deployer$encodedRequest", (Tag)specialData);
    }

    @Unique
    private <K, V, H> void deployer$encode(StockInventoryType<K, V, H> type, GenericOrderContained<V> order, CompoundTag tag, HolderLookup.Provider registries) {
        ResourceLocation id = DeployerRegistries.STOCK_INVENTORY.getKey(type);
        if (id == null) {
            return;
        }
        tag.put(id.toString(), (Tag)CatnipCodecUtils.encode(type.valueHandler().orderContainedCodec(), (HolderLookup.Provider)registries, order).orElseThrow());
    }
}

