/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.deployer.lib.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import com.simibubi.create.content.logistics.box.PackageItem;
import java.util.List;
import net.liukrast.deployer.lib.logistics.GenericPackageOrderData;
import net.liukrast.deployer.lib.logistics.packager.GenericPackageItem;
import net.liukrast.deployer.lib.logistics.packager.PackageProvidesCustomContent;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={PackageItem.class})
public class PackageItemMixin {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @WrapWithCondition(method={"<init>"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z")})
    private <E> boolean init(List<E> instance, E e) {
        Object t = PackageItem.class.cast(this);
        if (!(t instanceof GenericPackageItem)) return true;
        GenericPackageItem pack = (GenericPackageItem)((Object)t);
        if (!pack.cardboard) return false;
        return true;
    }

    @ModifyReturnValue(method={"getOrderId"}, at={@At(value="RETURN")})
    private static int getOrderId(int original, @Local(argsOnly=true, name={"arg0"}) ItemStack box) {
        Item item = box.getItem();
        if (!(item instanceof GenericPackageItem)) {
            return original;
        }
        GenericPackageItem generic = (GenericPackageItem)item;
        DataComponentType<GenericPackageOrderData<?>> data = generic.getType().packageHandler().packageOrderData();
        if (!box.has(data)) {
            return -1;
        }
        return ((GenericPackageOrderData)box.get(data)).orderId();
    }

    @ModifyReturnValue(method={"getContents"}, at={@At(value="RETURN")})
    private static ItemStackHandler getContents(ItemStackHandler original, @Local(argsOnly=true, name={"arg0"}) ItemStack box) {
        Item item = box.getItem();
        if (item instanceof PackageProvidesCustomContent) {
            PackageProvidesCustomContent custom = (PackageProvidesCustomContent)item;
            return custom.getCustomContents(box);
        }
        return original;
    }
}

