/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.deployer.lib.mixin;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Definitions;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllItems;
import com.simibubi.create.api.equipment.goggles.IHaveCustomOverlayIcon;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.compat.Mods;
import com.simibubi.create.content.contraptions.IDisplayAssemblyExceptions;
import com.simibubi.create.content.equipment.goggles.GoggleOverlayRenderer;
import com.simibubi.create.content.equipment.goggles.GogglesItem;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBox;
import com.simibubi.create.foundation.gui.RemovedGuiUtils;
import com.simibubi.create.foundation.mixin.accessor.MouseHandlerAccessor;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.gui.element.BoxElement;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.outliner.Outline;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.theme.Color;
import net.liukrast.deployer.lib.helper.DeployerGoggleInformation;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GoggleOverlayRenderer.class})
public abstract class GoggleOverlayRendererMixin {
    @Unique
    private static int santa_logistics$hoverTicks = 0;
    @Shadow
    @Final
    private static Map<Object, Outliner.OutlineEntry> outlines;

    @Unique
    private static void santa_logistics$renderOverlay4Entities(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        Color colorBorderBot;
        Minecraft mc = Minecraft.getInstance();
        assert (mc.gameMode != null);
        if (mc.options.hideGui || mc.gameMode.getPlayerMode() == GameType.SPECTATOR) {
            return;
        }
        HitResult objectMouseOver = mc.hitResult;
        if (!(objectMouseOver instanceof EntityHitResult)) {
            santa_logistics$hoverTicks = 0;
            return;
        }
        EntityHitResult result = (EntityHitResult)objectMouseOver;
        for (Outliner.OutlineEntry entry : outlines.values()) {
            Outline outline;
            if (!entry.isAlive() || !((outline = entry.getOutline()) instanceof ValueBox) || ((ValueBox)outline).isPassive) continue;
            return;
        }
        Entity entity = result.getEntity();
        ++santa_logistics$hoverTicks;
        boolean wearingGoggles = GogglesItem.isWearingGoggles((Player)mc.player);
        assert (mc.player != null);
        boolean isShifting = mc.player.isShiftKeyDown();
        boolean hasGoggleInformation = entity instanceof DeployerGoggleInformation;
        ItemStack item = AllItems.GOGGLES.asStack();
        ArrayList tooltip = new ArrayList();
        if (entity instanceof IHaveCustomOverlayIcon) {
            IHaveCustomOverlayIcon customOverlayIcon = (IHaveCustomOverlayIcon)entity;
            item = customOverlayIcon.getIcon(isShifting);
        }
        if (hasGoggleInformation && wearingGoggles) {
            IHaveGoggleInformation gte = (IHaveGoggleInformation)entity;
            gte.addToGoggleTooltip(tooltip, isShifting);
        }
        if (tooltip.isEmpty()) {
            santa_logistics$hoverTicks = 0;
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        int tooltipTextWidth = 0;
        for (FormattedText textLine : tooltip) {
            int textLineWidth = mc.font.width(textLine);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        int tooltipHeight = 8;
        if (tooltip.size() > 1) {
            tooltipHeight += 2;
            tooltipHeight += (tooltip.size() - 1) * 10;
        }
        int width = guiGraphics.guiWidth();
        int height = guiGraphics.guiHeight();
        CClient cfg = AllConfigs.client();
        int posX = width / 2 + (Integer)cfg.overlayOffsetX.get();
        int posY = height / 2 + (Integer)cfg.overlayOffsetY.get();
        posX = Math.min(posX, width - tooltipTextWidth - 20);
        posY = Math.min(posY, height - tooltipHeight - 20);
        float fade = Mth.clamp((float)(((float)santa_logistics$hoverTicks + deltaTracker.getGameTimeDeltaPartialTick(false)) / 24.0f), (float)0.0f, (float)1.0f);
        Boolean useCustom = (Boolean)cfg.overlayCustomColor.get();
        Color colorBackground = useCustom != false ? new Color(((Integer)cfg.overlayBackgroundColor.get()).intValue()) : BoxElement.COLOR_VANILLA_BACKGROUND.scaleAlpha(0.75f);
        Color colorBorderTop = useCustom != false ? new Color(((Integer)cfg.overlayBorderColorTop.get()).intValue()) : ((Color)BoxElement.COLOR_VANILLA_BORDER.getFirst()).copy();
        Color color = colorBorderBot = useCustom != false ? new Color(((Integer)cfg.overlayBorderColorBot.get()).intValue()) : ((Color)BoxElement.COLOR_VANILLA_BORDER.getSecond()).copy();
        if (fade < 1.0f) {
            poseStack.translate(Math.pow(1.0f - fade, 3.0) * (double)Math.signum((float)((Integer)cfg.overlayOffsetX.get()).intValue() + 0.5f) * 8.0, 0.0, 0.0);
            colorBackground.scaleAlpha(fade);
            colorBorderTop.scaleAlpha(fade);
            colorBorderBot.scaleAlpha(fade);
        }
        GuiGameElement.of((ItemStack)item).at((float)(posX + 10), (float)(posY - 16), 450.0f).render(guiGraphics);
        if (!Mods.MODERNUI.isLoaded()) {
            RemovedGuiUtils.drawHoveringText((GuiGraphics)guiGraphics, tooltip, (int)posX, (int)posY, (int)width, (int)height, (int)-1, (int)colorBackground.getRGB(), (int)colorBorderTop.getRGB(), (int)colorBorderBot.getRGB(), (Font)mc.font);
            poseStack.popPose();
            return;
        }
        MouseHandler mouseHandler = Minecraft.getInstance().mouseHandler;
        Window window = Minecraft.getInstance().getWindow();
        double guiScale = window.getGuiScale();
        double cursorX = mouseHandler.xpos();
        double cursorY = mouseHandler.ypos();
        ((MouseHandlerAccessor)mouseHandler).create$setXPos((double)Math.round(cursorX / guiScale) * guiScale);
        ((MouseHandlerAccessor)mouseHandler).create$setYPos((double)Math.round(cursorY / guiScale) * guiScale);
        RemovedGuiUtils.drawHoveringText((GuiGraphics)guiGraphics, tooltip, (int)posX, (int)posY, (int)width, (int)height, (int)-1, (int)colorBackground.getRGB(), (int)colorBorderTop.getRGB(), (int)colorBorderBot.getRGB(), (Font)mc.font);
        ((MouseHandlerAccessor)mouseHandler).create$setXPos(cursorX);
        ((MouseHandlerAccessor)mouseHandler).create$setYPos(cursorY);
        poseStack.popPose();
    }

    @Inject(method={"renderOverlay"}, at={@At(value="HEAD")})
    private static void renderOverlay(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        GoggleOverlayRendererMixin.santa_logistics$renderOverlay4Entities(guiGraphics, deltaTracker);
    }

    @Inject(method={"renderOverlay"}, at={@At(value="INVOKE", target="Ljava/util/ArrayList;<init>()V", shift=At.Shift.AFTER)})
    private static void renderOverlay$1(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci, @Local(name={"pos"}) BlockPos pos, @Local(name={"world"}) ClientLevel world, @Local(name={"hasGoggleInformation"}) boolean hasGoggleInformation, @Local(name={"item"}) LocalRef<ItemStack> item, @Local(name={"isShifting"}) boolean isShifting) {
        Block block;
        if (!hasGoggleInformation && (block = world.getBlockState(pos).getBlock()) instanceof DeployerGoggleInformation) {
            DeployerGoggleInformation info = (DeployerGoggleInformation)block;
            item.set((Object)info.getIcon(isShifting));
        }
    }

    @Inject(method={"renderOverlay"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definitions(value={@Definition(id="be", local={@Local(type=BlockEntity.class, name={"be"})}), @Definition(id="IDisplayAssemblyExceptions", type={IDisplayAssemblyExceptions.class})})
    @Expression(value={"be instanceof IDisplayAssemblyExceptions"})
    private static void renderOverlay$2(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci, @Local(name={"pos"}) BlockPos pos, @Local(name={"world"}) ClientLevel world, @Local(name={"isShifting"}) boolean isShifting, @Local(name={"goggleAddedInformation"}) LocalBooleanRef goggleAddedInformation, @Local(name={"tooltip"}) List<Component> tooltip, @Local(name={"wearingGoggles"}) boolean wearingGoggles) {
        Block block;
        if (wearingGoggles && (block = world.getBlockState(pos).getBlock()) instanceof DeployerGoggleInformation) {
            DeployerGoggleInformation info = (DeployerGoggleInformation)block;
            goggleAddedInformation.set(goggleAddedInformation.get() || info.addToGoogleTooltip((Level)world, pos, world.getBlockState(pos), tooltip, isShifting));
        }
    }
}

