/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.deployer.lib.mixin;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import net.liukrast.deployer.lib.DeployerConstants;
import net.liukrast.deployer.lib.logistics.board.AbstractPanelBehaviour;
import net.liukrast.deployer.lib.logistics.board.PanelType;
import net.liukrast.deployer.lib.mixinExtensions.FPBEExtension;
import net.liukrast.deployer.lib.registry.DeployerRegistries;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FactoryPanelBlockEntity.class})
public abstract class FactoryPanelBlockEntityMixin
extends SmartBlockEntity
implements FPBEExtension {
    @Shadow
    public EnumMap<FactoryPanelBlock.PanelSlot, FactoryPanelBehaviour> panels;
    @Unique
    private final List<ItemStack> deployer$extraDrops = new ArrayList<ItemStack>();

    @Override
    public List<ItemStack> deployer$getExtraDrops() {
        return this.deployer$extraDrops;
    }

    public FactoryPanelBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Inject(method={"read"}, at={@At(value="HEAD")})
    private void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket, CallbackInfo ci) {
        FactoryPanelBlockEntity instance = (FactoryPanelBlockEntity)FactoryPanelBlockEntity.class.cast(this);
        if (!tag.contains("CustomPanels")) {
            return;
        }
        CompoundTag customPanels = tag.getCompound("CustomPanels");
        for (FactoryPanelBlock.PanelSlot slot : FactoryPanelBlock.PanelSlot.values()) {
            AbstractPanelBehaviour behaviour;
            String key = CreateLang.asId((String)slot.name());
            if (!customPanels.contains(key)) continue;
            ResourceLocation id = ResourceLocation.parse((String)customPanels.getString(key));
            PanelType type = (PanelType)DeployerRegistries.PANEL.get(id);
            if (type == null) {
                DeployerConstants.LOGGER.error("Unable to find panel registry key {} for panel slot {} at pos {}", new Object[]{id, slot, this.getBlockPos()});
                continue;
            }
            FactoryPanelBehaviour current = this.panels.get(slot);
            if (current != null && type.asClass().equals(current.getClass()) || (behaviour = type.create(instance, slot)) == null) continue;
            this.panels.put(slot, behaviour);
            instance.attachBehaviourLate((BlockEntityBehaviour)behaviour);
        }
    }

    @Inject(method={"destroy"}, at={@At(value="HEAD")})
    private void destroy(CallbackInfo ci) {
        this.deployer$extraDrops.clear();
        for (FactoryPanelBehaviour panel : this.panels.values()) {
            ItemStack itemStack;
            if (!panel.active) continue;
            if (panel instanceof AbstractPanelBehaviour) {
                AbstractPanelBehaviour ab = (AbstractPanelBehaviour)panel;
                itemStack = ab.getItem().getDefaultInstance();
            } else {
                itemStack = AllBlocks.FACTORY_GAUGE.asStack();
            }
            this.deployer$extraDrops.add(itemStack);
        }
    }
}

