/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.deployer.lib.logistics.stockTicker;

import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.createmod.catnip.net.base.ClientboundPacketPayload;
import net.liukrast.deployer.lib.logistics.packager.StockInventoryType;
import net.liukrast.deployer.lib.mixinExtensions.STBEExtension;
import net.liukrast.deployer.lib.registry.DeployerPackets;
import net.liukrast.deployer.lib.registry.DeployerRegistries;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class LogisticalStockGenericResponsePacket<V>
implements ClientboundPacketPayload {
    public static final StreamCodec<RegistryFriendlyByteBuf, LogisticalStockGenericResponsePacket<?>> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, LogisticalStockGenericResponsePacket<?>>(){

        @NotNull
        public LogisticalStockGenericResponsePacket<?> decode(@NotNull RegistryFriendlyByteBuf buf) {
            boolean lastPacket = buf.readBoolean();
            BlockPos pos = (BlockPos)BlockPos.STREAM_CODEC.decode((Object)buf);
            StockInventoryType type = (StockInventoryType)DeployerRegistries.STOCK_INVENTORY.get(buf.readResourceLocation());
            assert (type != null);
            ArrayList<Object> list = new ArrayList<Object>();
            int size = buf.readVarInt();
            StreamCodec codec = type.valueHandler().streamCodec();
            for (int i = 0; i < size; ++i) {
                list.add(codec.decode((Object)buf));
            }
            return new LogisticalStockGenericResponsePacket(lastPacket, pos, type, list);
        }

        public void encode(@NotNull RegistryFriendlyByteBuf buf, @NotNull LogisticalStockGenericResponsePacket<?> p) {
            buf.writeBoolean(p.lastPacket);
            buf.writeBlockPos(p.pos);
            buf.writeResourceLocation(DeployerRegistries.STOCK_INVENTORY.getKey(p.type));
            p.type.valueHandler().streamCodec().apply(ByteBufCodecs.list()).encode((Object)buf, p.items);
        }
    };
    private final boolean lastPacket;
    private final BlockPos pos;
    private final StockInventoryType<?, V, ?> type;
    private final List<V> items;

    public LogisticalStockGenericResponsePacket(boolean lastPacket, BlockPos pos, StockInventoryType<?, V, ?> type, List<V> items) {
        this.lastPacket = lastPacket;
        this.pos = pos;
        this.type = type;
        this.items = items;
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return DeployerPackets.LOGISTICS_STOCK_RESPONSE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handle(LocalPlayer player) {
        BlockEntity blockEntity;
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null || !((blockEntity = level.getBlockEntity(this.pos)) instanceof StockTickerBlockEntity)) {
            return;
        }
        StockTickerBlockEntity stockTicker = (StockTickerBlockEntity)blockEntity;
        ((STBEExtension)stockTicker).deployer$receiveStockPacket(this.type, this.items, this.lastPacket);
    }
}

