/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.deployer.lib.logistics.stockTicker;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.packagerLink.WiFiEffectPacket;
import com.simibubi.create.content.logistics.redstoneRequester.RedstoneRequesterBlock;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.networking.BlockEntityConfigurationPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.liukrast.deployer.lib.logistics.packager.StockInventoryType;
import net.liukrast.deployer.lib.logistics.stockTicker.GenericOrderContained;
import net.liukrast.deployer.lib.mixinExtensions.STBEExtension;
import net.liukrast.deployer.lib.registry.DeployerPackets;
import net.liukrast.deployer.lib.registry.DeployerRegistries;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class GenericOrderRequestPacket
extends BlockEntityConfigurationPacket<StockTickerBlockEntity> {
    public static final StreamCodec<? super RegistryFriendlyByteBuf, GenericOrderRequestPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, GenericOrderRequestPacket>(){

        @NotNull
        public GenericOrderRequestPacket decode(@NotNull RegistryFriendlyByteBuf buf) {
            BlockPos pos = (BlockPos)BlockPos.STREAM_CODEC.decode((Object)buf);
            PackageOrderWithCrafts defaultOrder = (PackageOrderWithCrafts)PackageOrderWithCrafts.STREAM_CODEC.decode((Object)buf);
            List otherTypes = (List)ResourceLocation.STREAM_CODEC.apply(ByteBufCodecs.list()).decode((Object)buf);
            HashMap map = new HashMap();
            for (ResourceLocation otherType : otherTypes) {
                StockInventoryType type = (StockInventoryType)DeployerRegistries.STOCK_INVENTORY.get(otherType);
                assert (type != null);
                GenericOrderContained order = (GenericOrderContained)type.valueHandler().orderContainedStreamCodec().decode((Object)buf);
                map.put(type, order);
            }
            String address = (String)ByteBufCodecs.STRING_UTF8.decode((Object)buf);
            boolean encodeRequester = (Boolean)ByteBufCodecs.BOOL.decode((Object)buf);
            return new GenericOrderRequestPacket(pos, defaultOrder, map, address, encodeRequester);
        }

        public void encode(@NotNull RegistryFriendlyByteBuf buf, @NotNull GenericOrderRequestPacket p) {
            BlockPos.STREAM_CODEC.encode((Object)buf, (Object)p.pos);
            PackageOrderWithCrafts.STREAM_CODEC.encode((Object)buf, (Object)p.defaultOrder);
            ArrayList<ResourceLocation> toEncodeKeys = new ArrayList<ResourceLocation>();
            ArrayList<Runnable> toEncodeValues = new ArrayList<Runnable>();
            for (Map.Entry<StockInventoryType<?, ?, ?>, GenericOrderContained<?>> entry : p.types.entrySet()) {
                StockInventoryType<?, ?, ?> type = entry.getKey();
                toEncodeKeys.add(DeployerRegistries.STOCK_INVENTORY.getKey(entry.getKey()));
                StreamCodec<RegistryFriendlyByteBuf, GenericOrderContained<?>> codec = type.valueHandler().orderContainedStreamCodec();
                toEncodeValues.add(() -> codec.encode((Object)buf, (Object)((GenericOrderContained)entry.getValue())));
            }
            ResourceLocation.STREAM_CODEC.apply(ByteBufCodecs.list()).encode((Object)buf, toEncodeKeys);
            for (Runnable elem : toEncodeValues) {
                elem.run();
            }
            ByteBufCodecs.STRING_UTF8.encode((Object)buf, (Object)p.address);
            ByteBufCodecs.BOOL.encode((Object)buf, (Object)p.encodeRequester);
        }
    };
    private final PackageOrderWithCrafts defaultOrder;
    private final Map<StockInventoryType<?, ?, ?>, GenericOrderContained<?>> types;
    private final String address;
    private final boolean encodeRequester;

    public GenericOrderRequestPacket(BlockPos pos, PackageOrderWithCrafts defaultOrder, Map<StockInventoryType<?, ?, ?>, GenericOrderContained<?>> orders, String address, boolean encodeRequester) {
        super(pos);
        this.defaultOrder = defaultOrder;
        this.types = orders;
        this.address = address;
        this.encodeRequester = encodeRequester;
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return DeployerPackets.GENERIC_ORDER_REQUEST;
    }

    protected void applySettings(ServerPlayer player, StockTickerBlockEntity be) {
        boolean orderNotEmpty;
        boolean bl = orderNotEmpty = !this.defaultOrder.isEmpty() || this.types.values().stream().anyMatch(r -> !r.isEmpty());
        if (this.encodeRequester) {
            if (orderNotEmpty) {
                AllSoundEvents.CONFIRM.playOnServer(be.getLevel(), (Vec3i)this.pos);
            }
            player.closeContainer();
            RedstoneRequesterBlock.programRequester((ServerPlayer)player, (StockTickerBlockEntity)be, (PackageOrderWithCrafts)this.defaultOrder, (String)this.address);
            return;
        }
        if (orderNotEmpty) {
            AllSoundEvents.STOCK_TICKER_REQUEST.playOnServer(be.getLevel(), (Vec3i)this.pos);
            AllAdvancements.STOCK_TICKER.awardTo((Player)player);
            WiFiEffectPacket.send((Level)player.level(), (BlockPos)this.pos);
        }
        ((STBEExtension)be).deployer$broadcastAllPackageRequest(this.defaultOrder, LogisticallyLinkedBehaviour.RequestType.PLAYER, this.types, this.address);
    }
}

