/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.deployer.lib.logistics.packagerLink;

import com.google.common.cache.Cache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.simibubi.create.api.packager.InventoryIdentifier;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import com.simibubi.create.content.logistics.packager.PackagingRequest;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.packagerLink.LogisticsManager;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import com.simibubi.create.foundation.utility.TickBasedCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.function.IntSupplier;
import net.createmod.catnip.data.Pair;
import net.liukrast.deployer.lib.DeployerConstants;
import net.liukrast.deployer.lib.logistics.packager.AbstractInventorySummary;
import net.liukrast.deployer.lib.logistics.packager.AbstractPackagerBlockEntity;
import net.liukrast.deployer.lib.logistics.packager.GenericPackagingRequest;
import net.liukrast.deployer.lib.logistics.packager.IdentifiedContainer;
import net.liukrast.deployer.lib.logistics.packager.StockInventoryType;
import net.liukrast.deployer.lib.logistics.stockTicker.GenericOrderContained;
import net.liukrast.deployer.lib.mixin.LogisticsManagerAccessor;
import net.liukrast.deployer.lib.mixinExtensions.LLBExtension;
import net.liukrast.deployer.lib.mixinExtensions.PRExtension;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public class LogisticsGenericManager {
    private static final Map<StockInventoryType<?, ?, ?>, Cache<UUID, AbstractInventorySummary<?, ?>>> ACCURATE_SUMMARIES = new HashMap();
    private static final Map<StockInventoryType<?, ?, ?>, Cache<UUID, AbstractInventorySummary<?, ?>>> SUMMARIES = new HashMap();

    public static <K, V, H> Cache<UUID, AbstractInventorySummary<K, V>> getAccurateSummaries(StockInventoryType<K, V, H> type) {
        return ACCURATE_SUMMARIES.computeIfAbsent(type, k -> new TickBasedCache(1, false));
    }

    public static <K, V, H> Cache<UUID, AbstractInventorySummary<K, V>> getSummaries(StockInventoryType<K, V, H> type) {
        return SUMMARIES.computeIfAbsent(type, k -> new TickBasedCache(20, false));
    }

    public static <K, V, H> AbstractInventorySummary<K, V> getSummaryOfNetwork(StockInventoryType<K, V, H> type, UUID freqId, boolean accurate) {
        try {
            return (AbstractInventorySummary)(accurate ? LogisticsGenericManager.getAccurateSummaries(type) : LogisticsGenericManager.getSummaries(type)).get((Object)freqId, () -> {
                AbstractInventorySummary summaryOfLinks = type.networkHandler().createSummary();
                HashSet processedInventories = new HashSet();
                LogisticallyLinkedBehaviour.getAllPresent((UUID)freqId, (boolean)false).forEach(link -> {
                    AbstractInventorySummary empty;
                    InventoryIdentifier currentInventoryId = LogisticsManagerAccessor.invokeGetInventoryIdentifierFromLink(link);
                    if (currentInventoryId != null && !processedInventories.add(currentInventoryId)) {
                        return;
                    }
                    AbstractInventorySummary summary = ((LLBExtension)link).deployer$getSummary(type, null);
                    if (summary != (empty = type.networkHandler().empty())) {
                        ++summaryOfLinks.contributingLinks;
                        summaryOfLinks.add(summary);
                    }
                });
                return summaryOfLinks;
            });
        }
        catch (ExecutionException e) {
            DeployerConstants.LOGGER.error("Failed to get summary of network", (Throwable)e);
            return type.networkHandler().empty();
        }
    }

    public static <K, V, H> int getStockOf(StockInventoryType<K, V, H> type, UUID freqId, V stack, @Nullable IdentifiedContainer<H> ignoredHandler) {
        int sum = 0;
        for (LogisticallyLinkedBehaviour link : LogisticallyLinkedBehaviour.getAllPresent((UUID)freqId, (boolean)false)) {
            sum += ((LLBExtension)link).deployer$getSummary(type, ignoredHandler).getCountOf(stack);
        }
        return sum;
    }

    public static <K, V, H> boolean broadcastPackageRequest(StockInventoryType<K, V, H> type, UUID freqId, LogisticallyLinkedBehaviour.RequestType requestType, GenericOrderContained<V> order, @Nullable IdentifiedContainer<H> ignoredHandler, String address, int index, boolean isFinal) {
        return LogisticsGenericManager.broadcastPackageRequest(type, freqId, requestType, order, ignoredHandler, address, () -> LogisticsManagerAccessor.getR().nextInt(), index, isFinal);
    }

    public static <K, V, H> boolean broadcastPackageRequest(StockInventoryType<K, V, H> type, UUID freqId, LogisticallyLinkedBehaviour.RequestType requestType, GenericOrderContained<V> order, @Nullable IdentifiedContainer<H> ignoredHandler, String address, IntSupplier id, int index, boolean isFinal) {
        if (order.isEmpty()) {
            return false;
        }
        Multimap<AbstractPackagerBlockEntity<K, V, H>, GenericPackagingRequest<V>> requests = LogisticsGenericManager.findPackagersForRequest(type, freqId, order, ignoredHandler, address, id);
        for (AbstractPackagerBlockEntity packager : requests.keySet()) {
            if (packager == null || !packager.isTooBusyFor(requestType)) continue;
            return false;
        }
        LogisticsGenericManager.performPackageRequests(requests, index, isFinal);
        return true;
    }

    public static boolean broadcastAllPackageRequest(PackageOrderWithCrafts defaultOrder, UUID freqId, LogisticallyLinkedBehaviour.RequestType type, Map<StockInventoryType<?, ?, ?>, GenericOrderContained<?>> rq, String address) {
        int id;
        if (defaultOrder.isEmpty() && rq.values().stream().allMatch(GenericOrderContained::isEmpty)) {
            return false;
        }
        Multimap requests = LogisticsManager.findPackagersForRequest((UUID)freqId, (PackageOrderWithCrafts)defaultOrder, null, (String)address);
        for (PackagerBlockEntity packager : requests.keySet()) {
            if (!packager.isTooBusyFor(type)) continue;
            return false;
        }
        Collection vals = requests.values();
        int n = id = vals.isEmpty() ? LogisticsManagerAccessor.getR().nextInt() : Optional.ofNullable((PackagingRequest)vals.iterator().next()).map(PackagingRequest::orderId).orElseGet(() -> LogisticsManagerAccessor.getR().nextInt()).intValue();
        if (!rq.isEmpty()) {
            int index = vals.isEmpty() ? 0 : 1;
            Iterator<Map.Entry<StockInventoryType<?, ?, ?>, GenericOrderContained<?>>> it = rq.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<StockInventoryType<?, ?, ?>, GenericOrderContained<?>> entry = it.next();
                boolean isLast = !it.hasNext();
                LogisticsGenericManager.broadcastPackageRequest(entry.getKey(), freqId, type, entry.getValue(), null, address, () -> id, index, isLast);
                ++index;
            }
            requests.values().forEach(pr -> ((PRExtension)PRExtension.class.cast(pr)).deployer$flag());
        }
        LogisticsManager.performPackageRequests((Multimap)requests);
        return true;
    }

    public static <K, V, H> Multimap<AbstractPackagerBlockEntity<K, V, H>, GenericPackagingRequest<V>> findPackagersForRequest(StockInventoryType<K, V, H> type, UUID freqId, GenericOrderContained<V> order, @javax.annotation.Nullable IdentifiedContainer<H> ignoredHandler, String address, IntSupplier id) {
        ArrayList<V> stacks = new ArrayList<V>();
        for (V stack : order.stacks()) {
            if (type.valueHandler().isEmpty(stack) || type.valueHandler().getCount(stack) <= 0) continue;
            stacks.add(stack);
        }
        HashMultimap requests = HashMultimap.create();
        Collection availableLinks = LogisticallyLinkedBehaviour.getAllPresent((UUID)freqId, (boolean)true);
        ArrayList<LogisticallyLinkedBehaviour> usedLinks = new ArrayList<LogisticallyLinkedBehaviour>();
        MutableBoolean finalLinkTracker = new MutableBoolean(false);
        GenericOrderContained<V> context = order;
        int orderId = id.getAsInt();
        block1: for (int i = 0; i < stacks.size(); ++i) {
            Object entry = stacks.get(i);
            int remainingCount = type.valueHandler().getCount(entry);
            boolean finalEntry = i == stacks.size() - 1;
            for (LogisticallyLinkedBehaviour link : availableLinks) {
                Pair<AbstractPackagerBlockEntity<K, V, H>, GenericPackagingRequest<V>> request;
                int usedIndex = usedLinks.indexOf(link);
                int linkIndex = usedIndex == -1 ? usedLinks.size() : usedIndex;
                MutableBoolean isFinalLink = new MutableBoolean(false);
                if (linkIndex == usedLinks.size() - 1) {
                    isFinalLink = finalLinkTracker;
                }
                if ((request = ((LLBExtension)link).deployer$processRequests(type, entry, remainingCount, address, linkIndex, isFinalLink, orderId, context, ignoredHandler)) == null) continue;
                requests.put((Object)((AbstractPackagerBlockEntity)((Object)request.getFirst())), (Object)((GenericPackagingRequest)request.getSecond()));
                int processedCount = ((GenericPackagingRequest)request.getSecond()).getCount();
                if (processedCount > 0 && usedIndex == -1) {
                    context = null;
                    usedLinks.add(link);
                    finalLinkTracker = isFinalLink;
                }
                if ((remainingCount -= processedCount) > 0) continue;
                if (!finalEntry) continue block1;
                finalLinkTracker.setTrue();
                continue block1;
            }
        }
        return requests;
    }

    public static <K, V, H> void performPackageRequests(Multimap<AbstractPackagerBlockEntity<K, V, H>, GenericPackagingRequest<V>> requests, int index, boolean isFinal) {
        Map asMap = requests.asMap();
        for (Map.Entry entry : asMap.entrySet()) {
            ArrayList queuedRequests = new ArrayList((Collection)entry.getValue());
            AbstractPackagerBlockEntity packager = (AbstractPackagerBlockEntity)((Object)entry.getKey());
            if (!queuedRequests.isEmpty()) {
                packager.flashLink();
            }
            for (int i = 0; i < 100 && !queuedRequests.isEmpty(); ++i) {
                packager.attemptToSendSpecial(queuedRequests, index, isFinal);
            }
            packager.triggerStockCheck();
            packager.notifyUpdate();
        }
    }
}

