/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.deployer.lib.logistics.packager;

import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.Optional;
import java.util.function.Supplier;
import net.liukrast.deployer.lib.logistics.packager.AbstractPackagerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;

public class SimplePackagerBlock
extends AbstractPackagerBlock {
    private final Supplier<BlockEntityType<? extends PackagerBlockEntity>> blockEntityTypeSupplier;
    private final BlockCapability<?, ?> cap;
    private final Optional<PartialModel> trayModel;

    public SimplePackagerBlock(BlockBehaviour.Properties properties, Supplier<BlockEntityType<? extends PackagerBlockEntity>> blockEntityTypeSupplier, BlockCapability<?, ?> cap) {
        this(properties, blockEntityTypeSupplier, cap, Optional.empty());
    }

    public SimplePackagerBlock(BlockBehaviour.Properties properties, Supplier<BlockEntityType<? extends PackagerBlockEntity>> blockEntityTypeSupplier, BlockCapability<?, ?> cap, Optional<PartialModel> trayModel) {
        super(properties);
        this.blockEntityTypeSupplier = blockEntityTypeSupplier;
        this.cap = cap;
        this.trayModel = trayModel;
    }

    @Override
    public BlockEntityType<? extends PackagerBlockEntity> getBlockEntityType() {
        return this.blockEntityTypeSupplier.get();
    }

    @Override
    public boolean isSideValid(BlockEntity be) {
        if (!be.hasLevel()) {
            return false;
        }
        assert (be.getLevel() != null);
        return be.getLevel().getCapability(this.cap, be.getBlockPos(), null) != null;
    }

    @Override
    public PartialModel getTrayModel(BlockState blockState, PartialModel original) {
        return this.trayModel.orElse(original);
    }
}

