/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.deployer.lib.logistics.packager;

import com.simibubi.create.content.logistics.box.PackageItem;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.liukrast.deployer.lib.logistics.GenericPackageOrderData;
import net.liukrast.deployer.lib.logistics.packager.CustomPackageStyle;
import net.liukrast.deployer.lib.logistics.packager.StockInventoryType;
import net.liukrast.deployer.lib.logistics.stockTicker.GenericOrderContained;
import net.liukrast.deployer.lib.registry.DeployerRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class GenericPackageItem
extends PackageItem {
    public final boolean cardboard;
    private final Supplier<StockInventoryType<?, ?, ?>> type;
    private final String descriptionId;

    public GenericPackageItem(Item.Properties properties, CustomPackageStyle style, Supplier<StockInventoryType<?, ?, ?>> type) {
        this(properties, style, false, type, null);
    }

    public GenericPackageItem(Item.Properties properties, CustomPackageStyle style, Supplier<StockInventoryType<?, ?, ?>> type, String descriptionId) {
        this(properties, style, false, type, descriptionId);
    }

    public GenericPackageItem(Item.Properties properties, CustomPackageStyle style, boolean cardboard, Supplier<StockInventoryType<?, ?, ?>> type, String descriptionId) {
        super(properties, style.toOriginal());
        this.cardboard = cardboard;
        this.type = type;
        this.descriptionId = descriptionId;
    }

    public StockInventoryType<?, ?, ?> getType() {
        return this.type.get();
    }

    public static <K, V, H> void setOrder(StockInventoryType<K, V, H> type, ItemStack box, int orderId, int linkIndex, boolean isFinalLink, int fragmentIndex, boolean isFinal, @Nullable GenericOrderContained<V> orderContext) {
        GenericPackageOrderData<V> order = new GenericPackageOrderData<V>(orderId, linkIndex, isFinalLink, fragmentIndex, isFinal, orderContext);
        box.set(type.networkHandler().getComponent(), order);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, tooltipContext, tooltipComponents, tooltipFlag);
        for (StockInventoryType type : DeployerRegistries.STOCK_INVENTORY) {
            GenericPackageItem.handleType(type, stack, tooltipContext, tooltipComponents, tooltipFlag);
        }
    }

    private static <K, V, H> void handleType(StockInventoryType<K, V, H> type, ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        H content = type.packageHandler().getContents(stack);
        if (content == null) {
            return;
        }
        type.packageHandler().appendHoverText(stack, tooltipContext, tooltipComponents, tooltipFlag, content);
    }

    @NotNull
    public String getDescriptionId() {
        if (this.descriptionId == null) {
            return super.getDescriptionId();
        }
        return this.descriptionId;
    }
}

