/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.deployer.lib.logistics.packager;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.packager.IdentifiedInventory;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.packager.PackagerBlock;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import com.simibubi.create.content.logistics.packager.PackagerItemHandler;
import com.simibubi.create.content.logistics.packager.PackagingRequest;
import com.simibubi.create.content.logistics.packagerLink.PackagerLinkBlock;
import com.simibubi.create.content.logistics.packagerLink.PackagerLinkBlockEntity;
import com.simibubi.create.content.logistics.packagerLink.RequestPromiseQueue;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.CapManipulationBehaviourBase;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.BlockFace;
import net.liukrast.deployer.lib.logistics.GenericPackageOrderData;
import net.liukrast.deployer.lib.logistics.OrderStockTypeData;
import net.liukrast.deployer.lib.logistics.packager.AbstractInventorySummary;
import net.liukrast.deployer.lib.logistics.packager.GenericPackageItem;
import net.liukrast.deployer.lib.logistics.packager.GenericPackagingRequest;
import net.liukrast.deployer.lib.logistics.packager.GenericUnpackingHandler;
import net.liukrast.deployer.lib.logistics.packager.IdentifiedContainer;
import net.liukrast.deployer.lib.logistics.packager.StockInventoryType;
import net.liukrast.deployer.lib.logistics.stockTicker.GenericOrderContained;
import net.liukrast.deployer.lib.mixin.PackagerBlockEntityAccessor;
import net.liukrast.deployer.lib.mixinExtensions.LLBExtension;
import net.liukrast.deployer.lib.mixinExtensions.RPQExtension;
import net.liukrast.deployer.lib.mixinExtensions.VITBExtension;
import net.liukrast.deployer.lib.registry.DeployerDataComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPackagerBlockEntity<K, V, H>
extends PackagerBlockEntity {
    public CapManipulationBehaviourBase<H, ? extends CapManipulationBehaviourBase<?, ?>> targetInventory;
    private AbstractInventorySummary<K, V> availableItems;

    public AbstractPackagerBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public boolean supportsBlockEntity(BlockEntity target) {
        return ((PackagerBlockEntityAccessor)((Object)this)).invokeSupportsBlockEntity(target);
    }

    protected abstract CapManipulationBehaviourBase<H, ? extends CapManipulationBehaviourBase<?, ?>> createTargetInventory();

    public abstract StockInventoryType<K, V, H> getStockType();

    public PartialModel getHatchModel(boolean isHatchOpen, PartialModel original) {
        return original;
    }

    @ApiStatus.OverrideOnly
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.targetInventory = this.createTargetInventory();
        behaviours.add((BlockEntityBehaviour)this.targetInventory);
    }

    @Deprecated
    @ApiStatus.Internal
    public InventorySummary getAvailableItems() {
        throw new IllegalCallerException("This function should not be invoked on abstract packagers");
    }

    @Deprecated
    @ApiStatus.Internal
    public void attemptToSend(List<PackagingRequest> queuedRequests) {
        throw new IllegalCallerException("This function should not be invoked on abstract packagers");
    }

    public void triggerStockCheck() {
        this.getAvailableStacks();
    }

    public AbstractInventorySummary<K, V> getAvailableStacks() {
        if (this.availableItems != null && ((VITBExtension)((PackagerBlockEntityAccessor)((Object)this)).getInvVersionTracker()).deployer$stillWaiting(this.targetInventory.getInventory())) {
            return this.availableItems;
        }
        StockInventoryType<K, V, H> type = this.getStockType();
        StockInventoryType.IStorageHandler<K, V, Object> handler = type.storageHandler();
        AbstractInventorySummary<K, V> availableItems = type.networkHandler().createSummary();
        Object targetInv = this.targetInventory.getInventory();
        if (targetInv == null || targetInv instanceof PackagerItemHandler) {
            this.availableItems = availableItems;
            return availableItems;
        }
        for (int slot = 0; slot < handler.getSlots(targetInv); ++slot) {
            availableItems.add(handler.getStackInSlot(targetInv, slot));
        }
        ((VITBExtension)((PackagerBlockEntityAccessor)((Object)this)).getInvVersionTracker()).deployer$awaitNewVersion(this.targetInventory.getInventory());
        this.submitNewArrivals(type, this.availableItems, availableItems);
        this.availableItems = availableItems;
        return availableItems;
    }

    private void submitNewArrivals(StockInventoryType<K, V, H> type, AbstractInventorySummary<K, V> before, AbstractInventorySummary<K, V> after) {
        if (before == null || after.isEmpty()) {
            return;
        }
        assert (this.level != null);
        StockInventoryType.IValueHandler<K, Object, H> handler = type.valueHandler();
        HashSet<RequestPromiseQueue> promiseQueues = new HashSet<RequestPromiseQueue>();
        for (Direction d : Iterate.directions) {
            Object object;
            if (!this.level.isLoaded(this.worldPosition.relative(d))) continue;
            BlockState adjacentState = this.level.getBlockState(this.worldPosition.relative(d));
            if (AllBlocks.FACTORY_GAUGE.has(adjacentState)) {
                if (FactoryPanelBlock.connectedDirection((BlockState)adjacentState) != d || !((object = this.level.getBlockEntity(this.worldPosition.relative(d))) instanceof FactoryPanelBlockEntity)) continue;
                FactoryPanelBlockEntity fpbe = (FactoryPanelBlockEntity)object;
                if (!fpbe.restocker) continue;
                object = fpbe.panels.values().iterator();
                while (object.hasNext()) {
                    FactoryPanelBehaviour behaviour = (FactoryPanelBehaviour)object.next();
                    if (!behaviour.isActive()) continue;
                    promiseQueues.add(behaviour.restockerPromises);
                }
            }
            if (!AllBlocks.STOCK_LINK.has(adjacentState) || PackagerLinkBlock.getConnectedDirection((BlockState)adjacentState) != d || !((object = this.level.getBlockEntity(this.worldPosition.relative(d))) instanceof PackagerLinkBlockEntity)) continue;
            PackagerLinkBlockEntity plbe = (PackagerLinkBlockEntity)object;
            UUID freqId = plbe.behaviour.freqId;
            if (!Create.LOGISTICS.hasQueuedPromises(freqId)) continue;
            promiseQueues.add(Create.LOGISTICS.getQueuedPromises(freqId));
        }
        if (promiseQueues.isEmpty()) {
            return;
        }
        for (Object entry : after.getStacks()) {
            before.add(entry, -handler.getCount(entry));
        }
        for (RequestPromiseQueue queue : promiseQueues) {
            for (V entry : before.getStacks()) {
                if (handler.getCount(entry) >= 0) continue;
                ((RPQExtension)queue).deployer$genericEnteredSystem(type, entry, -handler.getCount(entry));
            }
        }
    }

    public void attemptToSendSpecial(@Nullable List<GenericPackagingRequest<V>> queuedRequests) {
        this.attemptToSendSpecial(queuedRequests, 0, true);
    }

    public void attemptToSendSpecial(@Nullable List<GenericPackagingRequest<V>> queuedRequests, int index, boolean isFinal) {
        BlockEntity blockEntity;
        boolean requestQueue;
        if (!(queuedRequests != null || this.heldBox.isEmpty() && this.animationTicks == 0 && this.buttonCooldown <= 0)) {
            return;
        }
        Object targetInv = this.targetInventory.getInventory();
        if (targetInv == null || targetInv instanceof PackagerItemHandler) {
            return;
        }
        StockInventoryType<K, V, H> type = this.getStockType();
        boolean anyItemPresent = false;
        H extractedItems = type.storageHandler().create(type.storageHandler().getMaxPackageSlots());
        ItemStack extractedPackageItem = ItemStack.EMPTY;
        GenericPackagingRequest<V> nextRequest = null;
        String fixedAddress = null;
        int fixedOrderId = 0;
        int linkIndexInOrder = 0;
        boolean finalLinkInOrder = false;
        int packageIndexAtLink = 0;
        boolean finalPackageAtLink = false;
        GenericOrderContained<V> orderContext = null;
        boolean bl = requestQueue = queuedRequests != null;
        if (requestQueue && !queuedRequests.isEmpty()) {
            nextRequest = queuedRequests.getFirst();
            fixedAddress = nextRequest.address();
            fixedOrderId = nextRequest.orderId();
            linkIndexInOrder = nextRequest.linkIndex();
            finalLinkInOrder = nextRequest.finalLink().booleanValue();
            packageIndexAtLink = nextRequest.packageCounter().getAndIncrement();
            orderContext = nextRequest.context();
        }
        StockInventoryType.IStorageHandler<K, V, Object> handler = type.storageHandler();
        StockInventoryType.IValueHandler<K, V, H> valueHandler = type.valueHandler();
        block0: for (int i = 0; i < handler.getMaxPackageSlots(); ++i) {
            boolean continuePacking = true;
            block1: while (continuePacking) {
                continuePacking = false;
                for (int slot = 0; slot < handler.getSlots(targetInv); ++slot) {
                    boolean bulky;
                    int initialCount = requestQueue ? Math.min(handler.maxCountPerSlot(), nextRequest.getCount()) : handler.maxCountPerSlot();
                    V extracted = handler.extract(targetInv, valueHandler.copyWithCount(handler.getStackInSlot(targetInv, slot), initialCount), true);
                    if (valueHandler.isEmpty(extracted) || requestQueue && !valueHandler.equalsIgnoreCount(extracted, nextRequest.item())) continue;
                    boolean bl2 = bulky = !handler.isBulky(valueHandler.fromValue(extracted));
                    if (bulky && anyItemPresent) continue;
                    anyItemPresent = true;
                    int leftovers = handler.fill(extractedItems, valueHandler.copyWithCount(extracted, valueHandler.getCount(extracted)), false);
                    int transferred = valueHandler.getCount(extracted) - leftovers;
                    handler.extract(targetInv, valueHandler.copyWithCount(handler.getStackInSlot(targetInv, slot), transferred), false);
                    if (!requestQueue) {
                        if (!bulky) continue;
                        break block0;
                    }
                    nextRequest.subtract(transferred);
                    if (!nextRequest.isEmpty()) {
                        if (!bulky) continue;
                        break block0;
                    }
                    finalPackageAtLink = true;
                    queuedRequests.removeFirst();
                    if (queuedRequests.isEmpty()) break block0;
                    int previousCount = nextRequest.packageCounter().intValue();
                    nextRequest = queuedRequests.getFirst();
                    assert (fixedAddress != null);
                    if (!fixedAddress.equals(nextRequest.address()) || fixedOrderId != nextRequest.orderId()) break block0;
                    nextRequest.packageCounter().setValue(previousCount);
                    finalPackageAtLink = false;
                    continuePacking = true;
                    if (nextRequest.context() != null) {
                        orderContext = nextRequest.context();
                    }
                    if (!bulky) continue block1;
                    break block0;
                }
            }
        }
        if (!anyItemPresent) {
            if (nextRequest != null) {
                queuedRequests.removeFirst();
            }
            return;
        }
        ItemStack createdBox = extractedPackageItem.isEmpty() ? type.packageHandler().containing(extractedItems) : extractedPackageItem.copy();
        PackageItem.clearAddress((ItemStack)createdBox);
        if (fixedAddress != null) {
            PackageItem.addAddress((ItemStack)createdBox, (String)fixedAddress);
        }
        if (requestQueue) {
            GenericPackageItem.setOrder(type, createdBox, fixedOrderId, linkIndexInOrder, finalLinkInOrder, packageIndexAtLink, finalPackageAtLink, orderContext);
            createdBox.set(DeployerDataComponents.ORDER_STOCK_TYPE_DATA, (Object)new OrderStockTypeData(index, isFinal));
        }
        if (!requestQueue && !this.signBasedAddress.isBlank()) {
            PackageItem.addAddress((ItemStack)createdBox, (String)this.signBasedAddress);
        }
        BlockPos linkPos = ((PackagerBlockEntityAccessor)((Object)this)).invokeGetLinkPos();
        assert (this.level != null);
        if (extractedPackageItem.isEmpty() && linkPos != null && (blockEntity = this.level.getBlockEntity(linkPos)) instanceof PackagerLinkBlockEntity) {
            PackagerLinkBlockEntity pLBE = (PackagerLinkBlockEntity)blockEntity;
            ((LLBExtension)pLBE.behaviour).deployer$deductFromAccurateSummary(type, extractedItems);
        }
        if (!this.heldBox.isEmpty() || this.animationTicks != 0) {
            this.queuedExitingPackages.add(new BigItemStack(createdBox, 1));
            return;
        }
        this.heldBox = createdBox;
        this.animationInward = false;
        this.animationTicks = 20;
        ((PackagerBlockEntityAccessor)((Object)this)).getAdvancement().awardPlayer(AllAdvancements.PACKAGER);
        this.triggerStockCheck();
        this.notifyUpdate();
    }

    @Deprecated
    @ApiStatus.Internal
    public boolean isTargetingSameInventory(@Nullable IdentifiedInventory inventory) {
        throw new IllegalCallerException("Should not be invoked in FluidPackagerBlockEntity");
    }

    public boolean isTargetingSameContainer(@Nullable IdentifiedContainer<H> inventory) {
        if (inventory == null) {
            return false;
        }
        Object targetHandler = this.targetInventory.getInventory();
        if (targetHandler == null) {
            return false;
        }
        if (inventory.identifier() != null) {
            BlockFace face = this.targetInventory.getTarget().getOpposite();
            return inventory.identifier().contains(face);
        }
        return this.isSameInventoryFallback(targetHandler, inventory.handler());
    }

    private boolean isSameInventoryFallback(H first, H second) {
        if (first == second) {
            return true;
        }
        StockInventoryType.IStorageHandler<K, V, H> sh = this.getStockType().storageHandler();
        StockInventoryType.IValueHandler<K, V, H> vh = this.getStockType().valueHandler();
        for (int i = 0; i < sh.getSlots(second); ++i) {
            V stackInSlot = sh.getStackInSlot(second, i);
            if (vh.isEmpty(stackInSlot)) continue;
            for (int j = 0; j < sh.getSlots(first); ++j) {
                if (stackInSlot != sh.getStackInSlot(first, j)) continue;
                return true;
            }
            break;
        }
        return false;
    }

    private List<V> getNonEmptyStacks(H handler) {
        StockInventoryType.IStorageHandler<K, V, H> storage = this.getStockType().storageHandler();
        StockInventoryType.IValueHandler<K, V, H> value = this.getStockType().valueHandler();
        ArrayList<V> stacks = new ArrayList<V>();
        for (int i = 0; i < storage.getSlots(handler); ++i) {
            V stack = storage.getStackInSlot(handler, i);
            if (value.isEmpty(stack)) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    private GenericOrderContained<V> getOrderContext(ItemStack box) {
        StockInventoryType.IPackageHandler<K, V, H> type = this.getStockType().packageHandler();
        DataComponentType<GenericPackageOrderData<V>> packageOrderData = type.packageOrderData();
        DataComponentType<GenericOrderContained<V>> packageOrderContext = type.packageOrderContext();
        if (box.has(packageOrderData)) {
            GenericPackageOrderData data = (GenericPackageOrderData)box.get(packageOrderData);
            assert (data != null);
            return data.orderContext();
        }
        if (box.has(packageOrderContext)) {
            return (GenericOrderContained)box.get(packageOrderContext);
        }
        return null;
    }

    public boolean unwrapBox(ItemStack box, boolean simulate) {
        Item item = box.getItem();
        if (!(item instanceof GenericPackageItem)) {
            this.heldBox = box;
            this.animationInward = false;
            this.animationTicks = 20;
            this.notifyUpdate();
            return false;
        }
        GenericPackageItem generic = (GenericPackageItem)item;
        StockInventoryType<K, V, H> type = this.getStockType();
        if (generic.getType() != type) {
            this.heldBox = box;
            this.animationInward = false;
            this.animationTicks = 20;
            this.notifyUpdate();
            return false;
        }
        if (this.animationTicks > 0) {
            return false;
        }
        Objects.requireNonNull(this.level);
        StockInventoryType.IPackageHandler<K, V, H> ph = type.packageHandler();
        H contents = ph.getContents(box);
        List<V> items = this.getNonEmptyStacks(contents);
        if (items.isEmpty()) {
            return true;
        }
        GenericOrderContained<V> orderContext = this.getOrderContext(box);
        Direction facing = this.getBlockState().getOptionalValue((Property)PackagerBlock.FACING).orElse(Direction.UP);
        BlockPos target = this.worldPosition.relative(facing.getOpposite());
        BlockState targetState = this.level.getBlockState(target);
        GenericUnpackingHandler<V> handler = (GenericUnpackingHandler<V>)type.registry.get((StateHolder)targetState);
        GenericUnpackingHandler<V> toUse = handler != null ? handler : type.defaultUnpackProcedure;
        boolean unpacked = toUse.unpack(this.level, target, targetState, facing, items, orderContext, simulate);
        if (unpacked && !simulate) {
            this.previouslyUnwrapped = box;
            this.animationInward = true;
            this.animationTicks = 20;
            this.notifyUpdate();
        }
        return unpacked;
    }
}

